<?php

namespace App\Jobs\V1;

use App\Jobs\Vrm\SendMail;
use App\Mail\PasswordUpdatedMail;
use App\Models\User;
use App\Services\Sms\SmsNotifier;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Throwable;

class SendPasswordUpdatedJob
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $user;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        app(SmsNotifier::class)->sendToPhone(
            $this->user->phone,
            'Your password was updated successfully. If this was not you, contact support immediately.',
            'user_password_updated'
        );

        try {
            SendMail::dispatch($this->user->email, mailable: new PasswordUpdatedMail, notificationType: 'user_password_updated');
        } catch (Throwable $exception) {
            Log::warning('Password updated email dispatch failed.', [
                'user_id' => $this->user->id,
                'email' => $this->user->email,
                'message' => $exception->getMessage(),
            ]);
        }
    }
}
