<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SecurityOrderStatusMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function __construct(
        public string $recipientName,
        public string $securityName,
        public string $status,
        public int $quantity,
        public string $currencyCode,
        public float $totalAmount,
    ) {}

    public function envelope(): Envelope
    {
        $statusLabel = ucfirst($this->status);

        return new Envelope(
            subject: "Order {$statusLabel}: {$this->securityName}",
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.simple-message',
            with: [
                'greeting' => "Hello {$this->recipientName},",
                'intro' => "Your order for {$this->securityName} has been {$this->status}.",
                'lines' => [
                    "Quantity: {$this->quantity}",
                    "Total: {$this->currencyCode} ".number_format($this->totalAmount, 2),
                ],
                'actionText' => 'Open Portfolio',
                'actionUrl' => route('member.portfolio'),
                'outro' => 'Thank you for trading with us.',
            ],
        );
    }
}
