<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class NotificationState extends Model
{
    /** @use HasFactory<\Database\Factories\NotificationStateFactory> */
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'notification_id',
        'user_id',
        'read_at',
        'seen_at',
        'cleared_at',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'read_at' => 'datetime',
            'seen_at' => 'datetime',
            'cleared_at' => 'datetime',
            'is_active' => 'boolean',
        ];
    }

    public function notification(): BelongsTo
    {
        return $this->belongsTo(Notification::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
