<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SecurityOrder extends Model
{
    protected $fillable = [
        'user_id',
        'security_id',
        'wallet_id',
        'order_type',
        'status',
        'price_per_share',
        'quantity',
        'volume',
        'total_amount',
        'currency_code',
        'traded_at',
        'profit_loss_amount',
        'profit_loss_percent',
        'is_active',
        'notes',
        'approved_by',
        'approved_at',
    ];

    protected function casts(): array
    {
        return [
            'price_per_share' => 'decimal:4',
            'quantity' => 'integer',
            'volume' => 'integer',
            'total_amount' => 'decimal:4',
            'traded_at' => 'datetime',
            'profit_loss_amount' => 'decimal:4',
            'profit_loss_percent' => 'decimal:4',
            'is_active' => 'boolean',
            'approved_at' => 'datetime',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function security(): BelongsTo
    {
        return $this->belongsTo(Security::class);
    }

    public function wallet(): BelongsTo
    {
        return $this->belongsTo(Wallet::class);
    }

    public function approver(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }
}
