<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Wallet extends Model
{
    protected $fillable = [
        'user_id',
        'currency_code',
        'balance',
        'used_amount',
        'withdrawal_hold_amount',
        'earned_amount',
        'is_active',
    ];

    protected function casts(): array
    {
        return [
            'balance' => 'decimal:4',
            'used_amount' => 'decimal:4',
            'withdrawal_hold_amount' => 'decimal:4',
            'earned_amount' => 'decimal:4',
            'is_active' => 'boolean',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(WalletTransaction::class);
    }

    public function investments(): HasMany
    {
        return $this->hasMany(Investment::class);
    }

    public function getAvailableBalanceAttribute(): float
    {
        return (float) $this->balance - (float) $this->used_amount - (float) $this->withdrawal_hold_amount;
    }
}
