<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WalletTransaction extends Model
{
    protected $fillable = [
        'wallet_id',
        'user_id',
        'type',
        'provider',
        'status',
        'provider_status',
        'amount',
        'currency_code',
        'description',
        'phone_number',
        'transaction_code',
        'merchant_request_id',
        'checkout_request_id',
        'provider_reference',
        'provider_response',
        'meta',
        'approved_by',
        'approved_at',
        'processed_at',
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:4',
            'meta' => 'array',
            'provider_response' => 'array',
            'approved_at' => 'datetime',
            'processed_at' => 'datetime',
        ];
    }

    public function wallet(): BelongsTo
    {
        return $this->belongsTo(Wallet::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function approver(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public function canDownloadReceipt(): bool
    {
        $normalizedType = strtolower((string) $this->type);
        $normalizedStatus = strtolower((string) $this->status);

        $isDepositOrWithdraw = str_contains($normalizedType, 'deposit') || str_contains($normalizedType, 'withdraw');
        $isSuccessful = in_array($normalizedStatus, ['approved', 'completed', 'successful', 'success'], true);

        return $isDepositOrWithdraw && $isSuccessful;
    }
}
