<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class InvestmentClaimedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        protected string $currencyCode,
        protected float $amount,
    ) {}

    /**
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject(__('Investment return claimed'))
            ->greeting(__('Hello :name,', ['name' => $notifiable->name]))
            ->line(__('You have successfully claimed your investment return.'))
            ->line(__('Amount credited: :currency :amount', ['currency' => $this->currencyCode, 'amount' => number_format($this->amount, 2)]))
            ->action(__('View account'), route('member.account'))
            ->line(__('Thank you for using our application!'));
    }

    /**
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'currency_code' => $this->currencyCode,
            'amount' => $this->amount,
        ];
    }
}
