<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SecurityOrderStatusNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        protected string $securityName,
        protected string $status,
        protected int $quantity,
        protected string $currencyCode,
        protected float $totalAmount,
    ) {}

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $statusLabel = ucfirst($this->status);

        return (new MailMessage)
            ->subject("Order {$statusLabel}: {$this->securityName}")
            ->greeting("Hello {$notifiable->name},")
            ->line("Your order for {$this->securityName} has been {$this->status}.")
            ->line("Quantity: {$this->quantity}")
            ->line("Total: {$this->currencyCode} ".number_format($this->totalAmount, 2))
            ->action('Open Portfolio', route('member.portfolio'))
            ->line('Thank you for trading with us.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'security_name' => $this->securityName,
            'status' => $this->status,
            'quantity' => $this->quantity,
            'currency_code' => $this->currencyCode,
            'total_amount' => $this->totalAmount,
        ];
    }
}
