<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SubscriptionCreatedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        protected string $packageName,
        protected string $currencyCode,
        protected float $amount,
    ) {}

    /**
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject(__('Subscription created'))
            ->greeting(__('Hello :name,', ['name' => $notifiable->name]))
            ->line(__('Your investment subscription has been activated.'))
            ->line(__('Package: :name', ['name' => $this->packageName]))
            ->line(__('Amount: :currency :amount', ['currency' => $this->currencyCode, 'amount' => number_format($this->amount, 2)]))
            ->action(__('View investments'), route('member.investments'))
            ->line(__('Thank you for using our application!'));
    }

    /**
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'package_name' => $this->packageName,
            'currency_code' => $this->currencyCode,
            'amount' => $this->amount,
        ];
    }
}
