<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'key' => env('POSTMARK_API_KEY'),
    ],

    'resend' => [
        'key' => env('RESEND_API_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'rapidapi_nse' => [
        'host' => env('RAPIDAPI_NSE_HOST', 'nairobi-stock-exchange-nse.p.rapidapi.com'),
        'key' => env('RAPIDAPI_NSE_KEY'),
    ],

    'nse_provider' => env('NSE_PROVIDER', 'rapid'),

    'sms_provider' => env('SMS_PROVIDER', 'africastalking'),

    'admin_phones' => array_values(array_filter(array_map(
        static fn (string $phone): string => trim($phone),
        explode(',', (string) env('ADMIN_PHONES', ''))
    ))),

    'yahoo_nse' => [
        'base_url' => env('YAHOO_NSE_BASE_URL', 'https://query1.finance.yahoo.com'),
        'timeout' => (int) env('YAHOO_NSE_TIMEOUT', 8),
        'symbols' => array_filter(array_map('trim', explode(',', (string) env(
            'YAHOO_NSE_SYMBOLS',
            'ABSA,AMAC,BAT,BKG,BRIT,CARB,CIC,COOP,CRWN,DTK,EABL,EQTY,HFCK,SCOM,SCBK,SBIC,NSE,NCBA,KPLC,KQ,KCB,JUB,IMH,KEGN,TOTL,XPRS'
        )))),
    ],

    'mpesa' => [
        'env' => env('MPESA_ENV', 'sandbox'), // sandbox or production
        'consumer_key' => env('MPESA_CONSUMER_KEY'),
        'consumer_secret' => env('MPESA_CONSUMER_SECRET'),
        'short_code' => env('MPESA_SHORT_CODE'),
        'passkey' => env('MPESA_PASSKEY'),
        'callback_url' => env('MPESA_CALLBACK_URL'),
    ],

    'africastalking' => [
        'username' => env('AFRICASTALKING_USERNAME'),
        'api_key' => env('AFRICASTALKING_API_KEY'),
        'from' => env('AFRICASTALKING_FROM'),
    ],

    'infobip' => [
        'base_url' => env('INFOBIP_BASE_URL'),
        'api_key' => env('INFOBIP_API_KEY'),
        'from' => env('INFOBIP_FROM'),
    ],

];
