<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('securities', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('trading_name', 20)->unique();
            $table->string('logo')->nullable();
            $table->string('currency_code', 4)->default('KSH');
            $table->decimal('initial_listing_amount', 20, 4);
            $table->decimal('current_amount', 20, 4);
            $table->unsignedBigInteger('min_shares')->default(1);
            $table->unsignedBigInteger('max_shares_purchase')->default(0);
            $table->unsignedBigInteger('max_shares_holding')->default(0);
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            $table->index(['is_active', 'trading_name']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('securities');
    }
};
