<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('security_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('security_id')->constrained()->cascadeOnDelete();
            $table->foreignId('wallet_id')->constrained()->cascadeOnDelete();
            $table->string('order_type', 20)->default('buy');
            $table->string('status', 20)->default('pending');
            $table->decimal('price_per_share', 20, 4);
            $table->unsignedBigInteger('quantity');
            $table->unsignedBigInteger('volume')->default(0);
            $table->decimal('total_amount', 20, 4);
            $table->string('currency_code', 4)->default('USD');
            $table->timestamp('traded_at')->nullable();
            $table->decimal('profit_loss_amount', 20, 4)->nullable();
            $table->decimal('profit_loss_percent', 8, 4)->nullable();
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->foreignId('approved_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('approved_at')->nullable();
            $table->timestamps();

            $table->index(['user_id', 'status']);
            $table->index(['security_id', 'status']);
            $table->index(['user_id', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('security_orders');
    }
};
