<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('portfolio_holdings', function (Blueprint $table): void {
            $table->unsignedBigInteger('reserved_quantity')->default(0)->after('quantity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('portfolio_holdings', function (Blueprint $table): void {
            $table->dropColumn('reserved_quantity');
        });
    }
};
