<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('securities_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('security_id')
                ->constrained('securities')
                ->cascadeOnDelete();
            $table->decimal('price', 20, 4);
            $table->decimal('change_percent', 10, 4)->default(0);
            $table->string('source', 20)->default('manual');
            $table->timestamp('logged_at')->nullable();
            $table->timestamps();

            $table->index(['security_id', 'logged_at']);
            $table->index('source');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('securities_logs');
    }
};
