

// Vormia imports and initialization
import "./plugins/jquery";

import {
    loadSelect2,
    initSelect2,
    safeReinitializeSelect2,
} from "./plugins/select2";

import { initFlatpickr } from "./plugins/flatpickr";

import { setupLivewireHooks } from "./helpers/livewire-hooks";

document.addEventListener("DOMContentLoaded", async () => {
    console.log("jQuery version:", $.fn.jquery);

    const select2Loaded = await loadSelect2();
    if (select2Loaded) {
        initSelect2();
    } else {
        console.error("CRITICAL: Failed to load Select2");
    }

    initFlatpickr();

    if (window.Livewire) {
        setupLivewireHooks();
    } else {
        console.warn("Livewire not detected");
    }
});

// Swal
import Swal from "sweetalert2";
// Make it available globally with compact, softer green styling across popups.
window.Swal = Swal.mixin({
    width: "24rem",
    padding: "0.85rem",
    background: "#f7fcf7",
    color: "#166534",
    confirmButtonColor: "#16a34a",
    cancelButtonColor: "#84cc16",
    reverseButtons: true,
});
