/**
 * Landing/front page only. No imports from app.js.
 * e.g. to-top button scroll, mobile menu overlay
 */
document.addEventListener('DOMContentLoaded', () => {
	const toTop = document.querySelector('.front-landing .to-top');
	if (toTop) {
		toTop.addEventListener('click', (e) => {
			e.preventDefault();
			window.scrollTo({ top: 0, behavior: 'smooth' });
		});
	}

	// Mobile menu overlay: open/close and body scroll lock
	const trigger = document.getElementById('mobile-menu-trigger');
	const closeBtn = document.getElementById('mobile-menu-close');
	const overlay = document.getElementById('mobile-menu-overlay');

	function openMenu() {
		if (!overlay) return;
		overlay.classList.add('active');
		overlay.setAttribute('aria-hidden', 'false');
		document.body.style.overflow = 'hidden';
	}

	function closeMenu() {
		if (!overlay) return;
		overlay.classList.remove('active');
		overlay.setAttribute('aria-hidden', 'true');
		document.body.style.overflow = '';
	}

	if (trigger) {
		trigger.addEventListener('click', (e) => {
			e.preventDefault();
			openMenu();
		});
	}

	if (closeBtn) {
		closeBtn.addEventListener('click', (e) => {
			e.preventDefault();
			closeMenu();
		});
		closeBtn.addEventListener('keydown', (e) => {
			if (e.key === 'Enter' || e.key === ' ') {
				e.preventDefault();
				closeMenu();
			}
		});
	}

	if (overlay) {
		overlay.addEventListener('click', (e) => {
			if (e.target === overlay) closeMenu();
		});
	}
});
