@php
    $displayDate = $occurredAt ?: now()->format('jS M Y g:i A');
    $displayReference = $reference ?: 'N/A';
    $displayPhone = $phoneNumber ?: 'N/A';
    $digits = preg_replace('/\D+/', '', (string) $displayPhone);
    $maskedPhone = $displayPhone;

    if (is_string($displayPhone) && $displayPhone !== '' && strlen($digits) >= 9) {
        $maskedPhone = substr($digits, 0, 4) . '***' . substr($digits, -3);
    }

    $paymentType = ucfirst(str_replace('_', ' ', (string) $typeLabel));
    $statusLabel = ucfirst((string) $status);
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ziidi Trader Transaction Receipt</title>
</head>
<body style="margin:0;padding:0;background:#ececec;font-family:Arial,Helvetica,sans-serif;color:#0f172a;">
<table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="background:#ececec;padding:24px 0;">
    <tr>
        <td align="center">
            <table role="presentation" width="680" cellspacing="0" cellpadding="0" style="max-width:680px;width:100%;background:#f5f5f5;border:1px solid #d6d6d6;">
                <tr>
                    <td style="padding:22px 28px 8px;">
                        <div style="font-size:48px;line-height:1;color:#20a437;font-weight:700;">Ziidi Trader</div>
                        <div style="font-size:15px;color:#1b8f30;font-weight:700;letter-spacing:0.2px;">powered by M-PESA</div>
                    </td>
                </tr>
                <tr>
                    <td style="padding:6px 28px 2px;text-align:center;">
                        <div style="display:inline-block;width:0;height:0;border-top:45px solid transparent;border-bottom:45px solid transparent;border-left:155px solid #31c15a;transform:rotate(-24deg);"></div>
                    </td>
                </tr>
                <tr>
                    <td style="padding:10px 28px 6px;text-align:center;">
                        <div style="font-size:56px;color:#1fab3d;font-weight:800;line-height:1.1;">Hi {{ $recipientName }},</div>
                        <p style="margin:10px 0 0;font-size:24px;color:#10a83f;font-weight:700;">Thank you for making your payment with Ziidi Trader.</p>
                    </td>
                </tr>
                <tr>
                    <td style="padding:20px 28px;">
                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0">
                            <tr>
                                <td valign="top" width="46%" style="background:#2db548;color:#ffffff;padding:26px 22px;">
                                    <div style="font-size:50px;font-weight:800;line-height:1.15;">Total Amount Paid:</div>
                                    <div style="font-size:57px;font-weight:800;line-height:1.1;margin-top:14px;">{{ $currencyCode }} {{ number_format((float) $amount, 2) }}</div>
                                    <div style="margin-top:20px;border-top:1px solid rgba(255,255,255,.45);padding-top:14px;font-size:30px;letter-spacing:1px;">Phone Number: {{ $displayPhone }}</div>
                                </td>
                                <td valign="top" width="54%" style="padding:4px 0 4px 24px;font-size:34px;line-height:1.6;">
                                    <div>Date: <strong>{{ $displayDate }}</strong></div>
                                    <div>Received From: <strong>{{ $recipientName }}</strong></div>
                                    <div>Transaction No: <strong>{{ $displayReference }}</strong></div>
                                    <div>Payment Type: <strong>{{ $paymentType }}</strong></div>
                                    <div>Status: <strong>{{ $statusLabel }}</strong></div>
                                    <div>Phone Number: <strong>{{ $maskedPhone }}</strong></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="padding:10px 28px 2px;">
                        <div style="height:42px;background:repeating-linear-gradient(90deg,#111 0,#111 3px,transparent 3px,transparent 7px);"></div>
                        <p style="margin:14px 0 0;text-align:center;font-size:44px;color:#2caf49;font-weight:700;letter-spacing:2px;">ETR</p>
                    </td>
                </tr>
                <tr>
                    <td style="padding:34px 28px 26px;">
                        <p style="margin:0 0 16px;font-size:20px;line-height:1.5;color:#374151;">
                            If you did not initiate this transaction, contact support immediately.
                        </p>
                        <p style="margin:0 0 20px;">
                            <a href="{{ $actionUrl }}" style="display:inline-block;background:#2db548;color:#fff;text-decoration:none;padding:12px 20px;font-weight:700;border-radius:4px;font-size:16px;">
                                Open Account
                            </a>
                        </p>
                        <div style="border-top:3px solid #2db548;padding-top:14px;font-size:36px;color:#1ea83c;font-weight:700;">
                            Ziidi Trader
                        </div>
                        <div style="font-size:13px;color:#1b8f30;font-weight:700;letter-spacing:0.2px;">powered by M-PESA</div>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</body>
</html>
