<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

	<head>
		@include('partials.head')
	</head>

	<body class="min-h-screen bg-white dark:bg-zinc-800">
		<flux:sidebar sticky collapsible="mobile"
			class="border-e border-zinc-200 bg-zinc-50 dark:border-zinc-700 dark:bg-zinc-900">
			<flux:sidebar.header>
				<x-app-logo :sidebar="true" href="{{ route('admin.dashboard') }}" wire:navigate />
				<flux:sidebar.collapse class="lg:hidden" />
			</flux:sidebar.header>

			<flux:sidebar.nav>
				<flux:sidebar.group :heading="__('Platform')" class="grid">
					<flux:sidebar.item icon="home" :href="route('admin.dashboard')" :current="request()->routeIs('admin.dashboard')"
						wire:navigate>
						{{ __('Dashboard') }}
					</flux:sidebar.item>

					@if (auth()->user()?->isAdminOrSuperAdmin())
						<hr />

						<flux:navlist.group :heading="__('Investment')" class="grid">
							<flux:navlist.item icon="users" :href="route('admin.members.index')"
								:current="request()->routeIs('admin.members.*')" wire:navigate>
								{{ __('Members') }}
							</flux:navlist.item>

							<flux:navlist.item icon="banknotes" :href="route('admin.securities.index')"
								:current="request()->routeIs('admin.securities.*')" wire:navigate>
								{{ __('Securities') }}
							</flux:navlist.item>

							<flux:navlist.item icon="clipboard-document-check" :href="route('admin.trade-requests.index')"
								:current="request()->routeIs('admin.trade-requests.*') || request()->routeIs('admin.orders.*')" wire:navigate>
								{{ __('Trade Requests') }}
							</flux:navlist.item>

							<flux:navlist.item icon="document-text" :href="route('admin.trade-logs.index')"
								:current="request()->routeIs('admin.trade-logs.*')" wire:navigate>
								{{ __('Trade Logs') }}
							</flux:navlist.item>

							<flux:navlist.item icon="wallet" :href="route('admin.wallet-requests.index')"
								:current="request()->routeIs('admin.wallet-requests.*')" wire:navigate>
								{{ __('Wallet Requests') }}
							</flux:navlist.item>

							<flux:navlist.item icon="arrow-path" :href="route('admin.transactions.index')"
								:current="request()->routeIs('admin.transactions.*')" wire:navigate>
								{{ __('Transactions') }}
							</flux:navlist.item>

							<flux:navlist.item icon="clipboard-document-check" :href="route('admin.subscriptions.index')"
								:current="request()->routeIs('admin.subscriptions.*')" wire:navigate>
								{{ __('Subscriptions') }}
							</flux:navlist.item>

							<flux:navlist.item icon="document-text" :href="route('admin.investment-portfolio.index')"
								:current="request()->routeIs('admin.investment-portfolio.*')" wire:navigate>
								{{ __('Investment Portfolio') }}
							</flux:navlist.item>

							<flux:navlist.item icon="document-text" :href="route('admin.watchlists.index')"
								:current="request()->routeIs('admin.watchlists.*')" wire:navigate>
								{{ __('Watchlists') }}
							</flux:navlist.item>

							<flux:navlist.item icon="chat-bubble-left-ellipsis" :href="route('admin.community.index')"
								:current="request()->routeIs('admin.community.*')" wire:navigate>
								{{ __('Community') }}
							</flux:navlist.item>

							<flux:navlist.item icon="cube" :href="route('admin.investment-packages.index')"
								:current="request()->routeIs('admin.investment-packages.*')" wire:navigate>
								{{ __('Investment Packages') }}
							</flux:navlist.item>

							<flux:navlist.item icon="adjustments-horizontal" :href="route('admin.investment-settings.index')"
								:current="request()->routeIs('admin.investment-settings.*')" wire:navigate>
								{{ __('Investment & Withdrawal Settings') }}
							</flux:navlist.item>

							<flux:navlist.item icon="bell-alert" :href="route('admin.notifications-settings.index')"
								:current="request()->routeIs('admin.notifications-settings.*')" wire:navigate>
								{{ __('Notifications Settings') }}
							</flux:navlist.item>
						</flux:navlist.group>
					@endif

					@if (auth()->user()?->isAdminOrSuperAdmin())
						<hr />

						{{-- Currencies Menu Item --}}
						<flux:navlist.item icon="currency-dollar" :href="route('admin.atu.currencies.index')"
							:current="request()->routeIs('admin.atu.currencies.index') || request()->routeIs('admin.atu.currencies.create') || request()->routeIs('admin.atu.currencies.edit')"
							wire:navigate>
							{{ __('Currencies') }}
						</flux:navlist.item>

						{{-- Currency Logs Menu Item --}}
						<flux:navlist.item icon="document-text" :href="route('admin.atu.currencies.logs')"
							:current="request()->routeIs('admin.atu.currencies.logs')" wire:navigate>
							{{ __('Currency Logs') }}
						</flux:navlist.item>

						{{-- Currency Settings Menu Item --}}
						<flux:navlist.item icon="cog-6-tooth" :href="route('admin.atu.currencies.settings')"
							:current="request()->routeIs('admin.atu.currencies.settings')" wire:navigate>
							{{ __('Currency Settings') }}
						</flux:navlist.item>

						<flux:navlist.item icon="building-storefront" :href="route('admin.wallet-till.index')"
							:current="request()->routeIs('admin.wallet-till.index')" wire:navigate>
							{{ __('Wallet Till') }}
						</flux:navlist.item>
					@endif

					@if (auth()->user()?->isSuperAdmin())
						<hr />
						<flux:navlist.group :heading="__('Admin')" class="grid">
							<flux:navlist.item icon="shield-check" :href="route('admin.admins.index')"
								:current="request()->routeIs('admin.admins.*')" wire:navigate>
								{{ __('Admins') }}
							</flux:navlist.item>
						</flux:navlist.group>
					@endif
				</flux:sidebar.group>
			</flux:sidebar.nav>

			<flux:spacer />

			<x-desktop-user-menu class="hidden lg:block" :name="auth()->user()->name" />
		</flux:sidebar>


		<!-- Mobile User Menu -->
		<flux:header class="lg:hidden">
			<flux:sidebar.toggle class="lg:hidden" icon="bars-2" inset="left" />

			<flux:spacer />

			<flux:dropdown position="top" align="end">
				<flux:profile :initials="auth()->user()->initials()" icon-trailing="chevron-down" />

				<flux:menu>
					<flux:menu.radio.group>
						<div class="p-0 text-sm font-normal">
							<div class="flex items-center gap-2 px-1 py-1.5 text-start text-sm">
								<flux:avatar :name="auth()->user()->name" :initials="auth()->user()->initials()" />

								<div class="grid flex-1 text-start text-sm leading-tight">
									<flux:heading class="truncate">{{ auth()->user()->name }}</flux:heading>
									<flux:text class="truncate">{{ auth()->user()->email }}</flux:text>
								</div>
							</div>
						</div>
					</flux:menu.radio.group>

					<flux:menu.separator />

					<flux:menu.radio.group>
						<flux:menu.item :href="route('profile.edit')" icon="cog" wire:navigate>
							{{ __('Settings') }}
						</flux:menu.item>
					</flux:menu.radio.group>

					<flux:menu.separator />

					<form method="POST" action="{{ route('logout') }}" class="w-full">
						@csrf
						<flux:menu.item as="button" type="submit" icon="arrow-right-start-on-rectangle" class="w-full cursor-pointer"
							data-test="logout-button">
							{{ __('Log Out') }}
						</flux:menu.item>
					</form>
				</flux:menu>
			</flux:dropdown>
		</flux:header>

		{{ $slot }}

		@fluxScripts
	</body>

</html>
