<?php

use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;

new class extends Component {
    use WithNotifications;

    public string $sendNotificationEmail = '1';

    public string $sendNotificationSms = '1';

    public string $userOtpSms = '1';

    public string $userOtpEmail = '1';

    public string $userTransactionSms = '1';

    public string $userTransactionEmail = '1';

    public string $userWelcomeSms = '1';

    public string $userWelcomeEmail = '1';

    public string $userPasswordUpdatedSms = '1';

    public string $userPasswordUpdatedEmail = '1';

    public string $adminDepositSms = '1';

    public string $adminDepositEmail = '1';

    public string $adminTransactionSms = '1';

    public string $adminTransactionEmail = '1';

    public function mount(TradingSettingsService $settings): void
    {
        $this->sendNotificationEmail = $settings->emailNotificationsEnabled() ? '1' : '0';
        $this->sendNotificationSms = $settings->smsNotificationsEnabled() ? '1' : '0';
        $this->userOtpSms = $settings->getGranularNotificationRaw('notification_user_otp_sms_enabled') ? '1' : '0';
        $this->userOtpEmail = $settings->getGranularNotificationRaw('notification_user_otp_email_enabled') ? '1' : '0';
        $this->userTransactionSms = $settings->getGranularNotificationRaw('notification_user_transaction_sms_enabled') ? '1' : '0';
        $this->userTransactionEmail = $settings->getGranularNotificationRaw('notification_user_transaction_email_enabled') ? '1' : '0';
        $this->userWelcomeSms = $settings->getGranularNotificationRaw('notification_user_welcome_sms_enabled') ? '1' : '0';
        $this->userWelcomeEmail = $settings->getGranularNotificationRaw('notification_user_welcome_email_enabled') ? '1' : '0';
        $this->userPasswordUpdatedSms = $settings->getGranularNotificationRaw('notification_user_password_updated_sms_enabled') ? '1' : '0';
        $this->userPasswordUpdatedEmail = $settings->getGranularNotificationRaw('notification_user_password_updated_email_enabled') ? '1' : '0';
        $this->adminDepositSms = $settings->getGranularNotificationRaw('notification_admin_deposit_sms_enabled') ? '1' : '0';
        $this->adminDepositEmail = $settings->getGranularNotificationRaw('notification_admin_deposit_email_enabled') ? '1' : '0';
        $this->adminTransactionSms = $settings->getGranularNotificationRaw('notification_admin_transaction_sms_enabled') ? '1' : '0';
        $this->adminTransactionEmail = $settings->getGranularNotificationRaw('notification_admin_transaction_email_enabled') ? '1' : '0';
    }

    /**
     * @return array<int, array{sms_id: string, email_id: string, sms_prop: string, email_prop: string, label: string}>
     */
    protected function granularRows(): array
    {
        return [
            ['sms_id' => 'userOtpSms', 'email_id' => 'userOtpEmail', 'sms_prop' => 'userOtpSms', 'email_prop' => 'userOtpEmail', 'label' => __('User OTP (verification & password reset)')],
            ['sms_id' => 'userTransactionSms', 'email_id' => 'userTransactionEmail', 'sms_prop' => 'userTransactionSms', 'email_prop' => 'userTransactionEmail', 'label' => __('User transaction (deposit, withdrawal, invest, buy/sell orders, order status)')],
            ['sms_id' => 'userWelcomeSms', 'email_id' => 'userWelcomeEmail', 'sms_prop' => 'userWelcomeSms', 'email_prop' => 'userWelcomeEmail', 'label' => __('User welcome')],
            ['sms_id' => 'userPasswordUpdatedSms', 'email_id' => 'userPasswordUpdatedEmail', 'sms_prop' => 'userPasswordUpdatedSms', 'email_prop' => 'userPasswordUpdatedEmail', 'label' => __('User password updated')],
            ['sms_id' => 'adminDepositSms', 'email_id' => 'adminDepositEmail', 'sms_prop' => 'adminDepositSms', 'email_prop' => 'adminDepositEmail', 'label' => __('Admin deposit notification')],
            ['sms_id' => 'adminTransactionSms', 'email_id' => 'adminTransactionEmail', 'sms_prop' => 'adminTransactionSms', 'email_prop' => 'adminTransactionEmail', 'label' => __('Admin transaction (withdrawals/orders)')],
        ];
    }

    public function save(TradingSettingsService $settings): void
    {
        $validated = $this->validate([
            'sendNotificationEmail' => 'required|in:0,1',
            'sendNotificationSms' => 'required|in:0,1',
            'userOtpSms' => 'required|in:0,1',
            'userOtpEmail' => 'required|in:0,1',
            'userTransactionSms' => 'required|in:0,1',
            'userTransactionEmail' => 'required|in:0,1',
            'userWelcomeSms' => 'required|in:0,1',
            'userWelcomeEmail' => 'required|in:0,1',
            'userPasswordUpdatedSms' => 'required|in:0,1',
            'userPasswordUpdatedEmail' => 'required|in:0,1',
            'adminDepositSms' => 'required|in:0,1',
            'adminDepositEmail' => 'required|in:0,1',
            'adminTransactionSms' => 'required|in:0,1',
            'adminTransactionEmail' => 'required|in:0,1',
        ]);

        $settings->updateNotificationChannels(
            $validated['sendNotificationEmail'] === '1',
            $validated['sendNotificationSms'] === '1',
        );

        $settings->updateNotificationChannelsGranular([
            'notification_user_otp_sms_enabled' => $validated['userOtpSms'] === '1',
            'notification_user_otp_email_enabled' => $validated['userOtpEmail'] === '1',
            'notification_user_transaction_sms_enabled' => $validated['userTransactionSms'] === '1',
            'notification_user_transaction_email_enabled' => $validated['userTransactionEmail'] === '1',
            'notification_user_welcome_sms_enabled' => $validated['userWelcomeSms'] === '1',
            'notification_user_welcome_email_enabled' => $validated['userWelcomeEmail'] === '1',
            'notification_user_password_updated_sms_enabled' => $validated['userPasswordUpdatedSms'] === '1',
            'notification_user_password_updated_email_enabled' => $validated['userPasswordUpdatedEmail'] === '1',
            'notification_admin_deposit_sms_enabled' => $validated['adminDepositSms'] === '1',
            'notification_admin_deposit_email_enabled' => $validated['adminDepositEmail'] === '1',
            'notification_admin_transaction_sms_enabled' => $validated['adminTransactionSms'] === '1',
            'notification_admin_transaction_email_enabled' => $validated['adminTransactionEmail'] === '1',
        ]);

        $this->notifySuccess(__('Notification settings updated successfully.'));
    }
}; ?>

<div>
    <x-admin-panel>
        <x-slot name="header">{{ __('Notifications Settings') }}</x-slot>
        <x-slot name="desc">{{ __('Control whether system notifications are sent through Email and SMS.') }}</x-slot>

        {!! $this->renderNotification() !!}

        <form wire:submit="save" class="space-y-6 max-w-2xl">
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <div class="bg-white dark:bg-gray-800 px-4 py-5 sm:p-6 space-y-4">
                    <div>
                        <label for="sendNotificationEmail" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Send Notification via Email') }}</label>
                        <select id="sendNotificationEmail" wire:model="sendNotificationEmail"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                            <option value="1">{{ __('On') }}</option>
                            <option value="0">{{ __('Off') }}</option>
                        </select>
                        @error('sendNotificationEmail')
                            <span class="text-red-500 text-xs">{{ $message }}</span>
                        @enderror
                    </div>

                    <div>
                        <label for="sendNotificationSms" class="required block text-sm/6 font-medium text-gray-900 dark:text-gray-100">{{ __('Send Notification via SMS') }}</label>
                        <select id="sendNotificationSms" wire:model="sendNotificationSms"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                            <option value="1">{{ __('On') }}</option>
                            <option value="0">{{ __('Off') }}</option>
                        </select>
                        @error('sendNotificationSms')
                            <span class="text-red-500 text-xs">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

            <details class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <summary class="bg-white dark:bg-gray-800 px-4 py-3 cursor-pointer text-sm font-medium text-gray-900 dark:text-gray-100 hover:bg-gray-50 dark:hover:bg-gray-700">
                    {{ __('Per-type notification settings') }}
                </summary>
                <div class="border-t border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-800 px-4 py-5 sm:p-6 space-y-4">
                    <p class="text-sm text-gray-500 dark:text-gray-400">{{ __('Control each notification type individually. Global toggles above must be On for any notifications to be sent.') }}</p>
                    <div class="grid gap-4 sm:grid-cols-2">
                        @foreach ($this->granularRows() as $row)
                            <div class="rounded-lg border border-gray-200 dark:border-gray-600 p-4 space-y-3">
                                <h4 class="text-sm font-medium text-gray-900 dark:text-gray-100">{{ $row['label'] }}</h4>
                                <div class="flex gap-4">
                                    <div class="flex-1">
                                        <label for="{{ $row['sms_id'] }}" class="block text-xs text-gray-500 dark:text-gray-400">{{ __('SMS') }}</label>
                                        <select id="{{ $row['sms_id'] }}" wire:model="{{ $row['sms_prop'] }}"
                                            class="mt-0.5 block w-full rounded-md bg-white dark:bg-gray-700 px-2 py-1 text-sm text-gray-900 dark:text-gray-100">
                                            <option value="1">{{ __('On') }}</option>
                                            <option value="0">{{ __('Off') }}</option>
                                        </select>
                                    </div>
                                    <div class="flex-1">
                                        <label for="{{ $row['email_id'] }}" class="block text-xs text-gray-500 dark:text-gray-400">{{ __('Email') }}</label>
                                        <select id="{{ $row['email_id'] }}" wire:model="{{ $row['email_prop'] }}"
                                            class="mt-0.5 block w-full rounded-md bg-white dark:bg-gray-700 px-2 py-1 text-sm text-gray-900 dark:text-gray-100">
                                            <option value="1">{{ __('On') }}</option>
                                            <option value="0">{{ __('Off') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </details>

            <button type="submit"
                class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-indigo-500">
                {{ __('Save Settings') }}
            </button>
        </form>
    </x-admin-panel>
</div>
