@extends('layouts.member.auth')

@section('content')
    <div class="mb-4">
        <h1 class="text-xl font-bold text-foreground">{{ __('Forgot password') }}</h1>
        <p class="text-sm text-muted-foreground mt-1">{{ __('Enter your email to receive an 8-digit reset code') }}</p>
    </div>

    @if (session('status'))
        <div class="rounded-lg bg-primary/10 border border-primary/30 px-4 py-3 text-sm text-foreground mb-4">
            {{ session('status') }}
        </div>
    @endif

    @if ($errors->has('email'))
        <div class="rounded-lg bg-destructive/10 border border-destructive/30 px-4 py-3 text-sm text-foreground mb-4">
            {{ $errors->first('email') }}
        </div>
    @endif

    <form method="POST" action="{{ route('password.email') }}" class="flex flex-col gap-4">
        @csrf

        <div>
            <label for="email" class="required block text-sm font-medium text-foreground mb-1">{{ __('Email address') }}</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus
                placeholder="email@example.com"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
        </div>

        <button type="submit" class="w-full bg-primary text-primary-foreground font-semibold py-3 rounded-lg hover:opacity-90 transition-opacity">
            {{ __('Send reset code') }}
        </button>
    </form>

    <p class="text-center text-sm text-muted-foreground mt-4">
        {{ __('Or, return to') }}
        <a href="{{ route('login') }}" class="text-primary font-semibold" wire:navigate>{{ __('log in') }}</a>
    </p>
@endsection
