@extends('layouts.member.auth')

@section('content')
    <div class="mb-4">
        <h1 class="text-xl font-bold text-foreground">{{ __('Log in to your account') }}</h1>
        <p class="text-sm text-muted-foreground mt-1">{{ __('Enter your email and password below to log in') }}</p>
    </div>

    @if (session('status'))
        <div class="rounded-lg bg-primary/10 border border-primary/30 px-4 py-3 text-sm text-foreground mb-4">
            {{ session('status') }}
        </div>
    @endif

    @if (session('error'))
        <div class="rounded-lg bg-destructive/10 border border-destructive/30 px-4 py-3 text-sm text-foreground mb-4">
            {{ session('error') }}
        </div>
    @endif

    <form method="POST" action="{{ route('login.store') }}" class="flex flex-col gap-4">
        @csrf

        <div>
            <label for="email" class="required block text-sm font-medium text-foreground mb-1">{{ __('Email address') }}</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="email"
                placeholder="email@example.com"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('email')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="password" class="required block text-sm font-medium text-foreground mb-1">{{ __('Password') }}</label>
            <input id="password" type="password" name="password" required autocomplete="current-password"
                placeholder="{{ __('Password') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('password')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
            @if (Route::has('password.request'))
                <a href="{{ route('password.request') }}" class="text-sm text-primary font-medium mt-1 inline-block" wire:navigate>
                    {{ __('Forgot your password?') }}
                </a>
            @endif
        </div>

        <label class="flex items-center gap-2 text-sm text-muted-foreground cursor-pointer">
            <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}
                class="rounded border-border bg-card text-primary focus:ring-primary" />
            {{ __('Remember me') }}
        </label>

        <button type="submit" class="w-full bg-primary text-primary-foreground font-semibold py-3 rounded-lg hover:opacity-90 transition-opacity">
            {{ __('Log in') }}
        </button>
    </form>

    @if (Route::has('register'))
        <p class="text-center text-sm text-muted-foreground mt-4">
            {{ __("Don't have an account?") }}
            <a href="{{ route('register') }}" class="text-primary font-semibold" wire:navigate>{{ __('Sign up') }}</a>
        </p>
    @endif
@endsection
