@extends('layouts.member.auth')

@section('content')
    <div class="mb-4">
        <h1 class="text-xl font-bold text-foreground">{{ __('Reset password') }}</h1>
        <p class="text-sm text-muted-foreground mt-1">{{ __('Enter your reset code and new password') }}</p>
    </div>

    @if (session('status'))
        <div class="rounded-lg bg-primary/10 border border-primary/30 px-4 py-3 text-sm text-foreground mb-4">
            {{ session('status') }}
        </div>
    @endif

    <form method="POST" action="{{ route('password.update') }}" class="flex flex-col gap-4">
        @csrf

        <div>
            <label for="email" class="required block text-sm font-medium text-foreground mb-1">{{ __('Email') }}</label>
            <input id="email" type="email" name="email" value="{{ old('email', $email ?? request('email')) }}" required autocomplete="email"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('email')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="verification_code" class="required block text-sm font-medium text-foreground mb-1">{{ __('Reset code') }}</label>
            <input id="verification_code" type="text" name="verification_code" value="{{ old('verification_code') }}" required inputmode="numeric" maxlength="8"
                placeholder="{{ __('Enter 8-digit code') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('verification_code')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="password" class="required block text-sm font-medium text-foreground mb-1">{{ __('Password') }}</label>
            <input id="password" type="password" name="password" required autocomplete="new-password"
                placeholder="{{ __('Password') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
            @error('password')
                <p class="text-destructive text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="password_confirmation" class="required block text-sm font-medium text-foreground mb-1">{{ __('Confirm password') }}</label>
            <input id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password"
                placeholder="{{ __('Confirm password') }}"
                class="w-full bg-card border border-border rounded-lg py-3 px-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary" />
        </div>

        <button type="submit" class="w-full bg-primary text-primary-foreground font-semibold py-3 rounded-lg hover:opacity-90 transition-opacity">
            {{ __('Reset password and sign in') }}
        </button>
    </form>

    <p class="text-center text-sm text-muted-foreground mt-4">
        <a href="{{ route('password.request') }}" class="text-primary font-semibold" wire:navigate>{{ __('Start again') }}</a>
    </p>
@endsection
