@props(['securities' => [], 'currencyCode' => null])
@php
	$items = array_merge($securities, $securities);
	$currency = $currencyCode ?? app(\App\Services\DefaultCurrencyService::class)->code();
@endphp
<div class="overflow-hidden bg-background border-b border-border py-2">
	<div class="flex animate-marquee whitespace-nowrap">
		@foreach ($items as $s)
			<span class="inline-flex items-center gap-1.5 mx-4 text-sm">
				@if (!empty($s['logo']))
					<img src="{{ asset($s['logo']) }}" alt="" class="size-5 rounded-full object-cover shrink-0" />
				@else
					<span
						class="inline-flex size-5 shrink-0 items-center justify-center rounded-full bg-secondary text-[10px] font-bold text-foreground">
						{{ $s['initials'] ?? substr($s['symbol'] ?? 'ST', 0, 2) }}
					</span>
				@endif
				<span class="font-semibold text-foreground">{{ $s['symbol'] }}</span>
				<span class="text-muted-foreground">{{ $currency }} {{ number_format($s['price'], 2) }}</span>
				<span class="{{ $s['change'] >= 0 ? 'text-gain' : 'text-loss' }}">
					{{ $s['change'] >= 0 ? '▲' : '▼' }}{{ number_format(abs($s['change']), 2) }}%
				</span>
			</span>
		@endforeach
	</div>
</div>
