<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Deposit/Withdraw Receipt</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, Helvetica, sans-serif;
        }

        .receipt-canvas {
            position: relative;
            width: 720px;
            height: 1280px;
            overflow: hidden;
        }

        .receipt-base {
            position: absolute;
            left: 0;
            top: 0;
            width: 720px;
            height: 1280px;
        }

        .text-white {
            color: #ffffff;
        }

        .text-black {
            color: #111111;
        }

        .text-green {
            color: #45ad53;
        }

        .text-gray {
            color: #596066;
        }

        .fs-32 { font-size: 32px; }
        .fs-44 { font-size: 44px; }
        .fs-48 { font-size: 48px; }
        .fs-88 { font-size: 88px; }
        .fs-12 { font-size: 12px; }

        .pos {
            position: absolute;
            white-space: nowrap;
            line-height: 1;
        }
    </style>
</head>
<body>
<div class="receipt-canvas">
    <img class="receipt-base" src="{{ $baseImagePath }}" alt="Receipt Base">

    <div class="pos fs-12 text-gray" style="left: 189.87px; top: 1254.5px;">https://www.safaricom.co.ke</div>

    <div class="pos fs-88 text-green" style="left: 193.5px; top: 638px;">Hi {{ $firstName }},</div>
    <div class="pos fs-44 text-green" style="left: 55.5px; top: 666.5px;">{{ $paragraphText }}</div>

    <div class="pos fs-48 text-white" style="left: 75px; top: 747.5px;">Total Amount Paid:</div>
    <div class="pos fs-48 text-white" style="left: 96px; top: 777.5px;">{{ $currencyCode }} {{ $amount }}</div>
    <div class="pos fs-32 text-white" style="left: 75px; top: 822.5px;">Phone Number:</div>
    <div class="pos fs-32 text-white" style="left: 171px; top: 821px;">{{ $phoneOrBankAccountNumber }}</div>

    <div class="pos fs-32 text-black" style="left: 289.5px; top: 716px;">Date: {{ $dateTime }}</div>
    <div class="pos fs-32 text-black" style="left: 289.5px; top: 738.5px;">Received From: {{ $fullName }}</div>
    <div class="pos fs-32 text-black" style="left: 289.5px; top: 779px;">Transaction No:</div>
    <div class="pos fs-32 text-black" style="left: 375px; top: 777.5px;">{{ $transactionNo }}</div>
    <div class="pos fs-32 text-black" style="left: 289.5px; top: 803px;">Payment Type:</div>
    <div class="pos fs-32 text-black" style="left: 375px; top: 801.5px;">{{ $paymentType }}</div>
    <div class="pos fs-32 text-black" style="left: 289.5px; top: 827px;">Phone Number:</div>
    <div class="pos fs-32 text-black" style="left: 375px; top: 825.5px;">{{ $maskedPhoneNumber }}</div>
</div>
</body>
</html>
