<?php
use App\Models\WalletTransaction;
use App\Services\ReceiptPdfService;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <div class="mx-auto flex max-w-[420px] flex-wrap items-center justify-center gap-3 px-4 pb-4">
        <a
            href="<?php echo e(route('member.transactions')); ?>"
            wire:navigate
            class="inline-flex items-center gap-2 rounded-lg border border-border bg-card px-4 py-2.5 text-sm font-semibold text-foreground shadow-sm hover:bg-muted/60"
        >
            <i class="fa-solid fa-arrow-left" aria-hidden="true"></i>
            <?php echo e(__('Back')); ?>

        </a>
        <a
            href="<?php echo e(route('member.transactions.receipt.download', ['transaction' => $transactionId])); ?>"
            class="inline-flex items-center gap-2 rounded-lg bg-primary px-4 py-2.5 text-sm font-semibold text-primary-foreground shadow-sm hover:opacity-90"
        >
            <i class="fa-solid fa-file-pdf" aria-hidden="true"></i>
            <?php echo e(__('Download PDF')); ?>

        </a>
    </div>

    <?php echo $__env->make('partials.receipts.receipt', ['receipt' => $receipt], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/83b1e4d9.blade.php ENDPATH**/ ?>