<?php
use Livewire\Attributes\Computed;
use Livewire\Component;
?>

<div class="flex items-center gap-1 rounded-lg border border-border bg-muted/30 p-0.5">
    <button type="button"
        wire:click="setTheme('light')"
        class="inline-flex h-8 w-8 items-center justify-center rounded-md text-sm transition-colors <?php echo e($this->theme === 'light' ? 'bg-background text-foreground shadow-sm' : 'text-muted-foreground hover:text-foreground'); ?>"
        aria-label="<?php echo e(__('Light mode')); ?>">
        <i class="fa-solid fa-sun h-4 w-4"></i>
    </button>
    <button type="button"
        wire:click="setTheme('dark')"
        class="inline-flex h-8 w-8 items-center justify-center rounded-md text-sm transition-colors <?php echo e($this->theme === 'dark' ? 'bg-background text-foreground shadow-sm' : 'text-muted-foreground hover:text-foreground'); ?>"
        aria-label="<?php echo e(__('Dark mode')); ?>">
        <i class="fa-solid fa-moon h-4 w-4"></i>
    </button>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/e8799912.blade.php ENDPATH**/ ?>