<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['title' => config('app.name'), 'greeting' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['title' => config('app.name'), 'greeting' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
	$greetings = [__('Good Night'), __('Good Morning'), __('Good Afternoon'), __('Good Evening')];
	// Fallback for SSR / no-JS: same ranges as client (server time)
	$hour = (int) now()->format('H');
	$resolvedGreeting =
	    $greeting ??
	    match (true) {
	        $hour < 5 => $greetings[0],
	        $hour < 12 => $greetings[1],
	        $hour < 17 => $greetings[2],
	        $hour < 21 => $greetings[3],
	        default => $greetings[0],
	    };
?>

<header x-data="{
    scrolled: false,
    greeting: <?php echo \Illuminate\Support\Js::from($resolvedGreeting)->toHtml() ?>,
    greetings: <?php echo \Illuminate\Support\Js::from($greetings)->toHtml() ?>,
    updateGreeting() {
        const h = new Date().getHours();
        this.greeting = h < 5 ? this.greetings[0] : h < 12 ? this.greetings[1] : h < 17 ? this.greetings[2] : h < 21 ? this.greetings[3] : this.greetings[0];
    }
}" x-init="scrolled = window.scrollY > 6;
updateGreeting();
window.addEventListener('scroll', () => scrolled = window.scrollY > 6)"
	:class="scrolled ? 'bg-zinc-950 border-zinc-800' : 'bg-background border-border/80'"
	class="sticky top-0 z-40 border-b px-4 py-3 transition-colors duration-200">
	<div class="flex items-center justify-between gap-3">
		<div class="min-w-0">
			<h1 class="truncate font-display text-lg font-bold text-foreground sm:text-xl"><?php echo e(config('app.name', $title)); ?></h1>
			<p class="truncate text-sm font-medium text-muted-foreground" x-text="greeting"><?php echo e($resolvedGreeting); ?></p>
		</div>
		<div class="flex items-center gap-3">
			<?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('front.theme-switcher', []);

$key = null;
$__componentSlots = [];

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-2166329138-0', $key);

$__html = app('livewire')->mount($__name, $__params, $key, $__componentSlots);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__componentSlots);
unset($__split);
?>
			<?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('front.notifications-bell', []);

$key = null;
$__componentSlots = [];

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-2166329138-1', $key);

$__html = app('livewire')->mount($__name, $__params, $key, $__componentSlots);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__componentSlots);
unset($__split);
?>
			<a href="<?php echo e(route('logout')); ?>" class="inline-flex items-center text-sm transition-opacity hover:opacity-80"
				:class="scrolled ? 'text-white' : 'text-foreground'" aria-label="<?php echo e(__('Log out')); ?>"
				onclick="event.preventDefault(); document.getElementById('logout-form-trading').submit();">
				<i class="fa-solid fa-right-from-bracket h-6 w-6" :class="scrolled ? 'text-white' : 'text-foreground'"></i>
			</a>
			<form id="logout-form-trading" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
				<?php echo csrf_field(); ?>
			</form>
		</div>
	</div>
</header>
<?php /**PATH /home/ziidfelj/home.ziidi.trade/resources/views/partials/trading/topbar.blade.php ENDPATH**/ ?>