<?php
use App\Facades\Vrm\MediaForge;
use App\Models\Security;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Add Security')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Create a security mapping with logo, ticker name, and description.')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('button', null, []); ?> 
            <a href="<?php echo e(route('admin.securities.index')); ?>"
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                <?php echo e(__('Go Back')); ?>

            </a>
         <?php $__env->endSlot(); ?>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-5 mb-5 sm:p-6">
            <?php echo $this->renderNotification(); ?>


            <form wire:submit="save" class="space-y-6">
                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Ticker Name')); ?></label>
                        <input type="text" wire:model="trading_name"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 uppercase dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('trading_name')); ?></span>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Logo')); ?></label>
                        <input type="file" wire:model="logo" accept=".jpg,.jpeg,.png,.webp"
                            class="mt-1 block w-full cursor-pointer px-3 py-2 text-sm file:mr-4 file:rounded-md file:border-0 file:bg-gray-200 dark:file:bg-gray-600 file:px-3 file:py-1.5 file:text-sm file:font-semibold file:text-gray-900 dark:file:text-gray-100 hover:file:bg-gray-300 dark:hover:file:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('logo')); ?></span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($logo): ?>
                            <img src="<?php echo e($logo->temporaryUrl()); ?>" class="mt-2 h-16 w-16 rounded object-cover" alt="preview" />
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Description')); ?></label>
                    <textarea wire:model="description" rows="4"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 placeholder:text-gray-400 dark:placeholder:text-gray-500 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6"></textarea>
                    <span class="text-red-500 text-sm"><?php echo e($errors->first('description')); ?></span>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white hover:bg-indigo-500">
                        <?php echo e(__('Save Security')); ?>

                    </button>
                </div>
            </form>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/f41134c2.blade.php ENDPATH**/ ?>