<?php
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use App\Services\Trading\TradingSettingsService;
use App\Models\Wallet;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	<?php echo $__env->make('partials.trading.topbar', ['title' => 'Ziidi', 'greeting' => $this->greeting], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('partials.trading.marquee', [
        'securities' => $this->securities,
        'currencyCode' => $this->defaultCurrencyCode,
    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

	<div class="px-4 py-4 space-y-5">
		<section class="dashboard-balance-card rounded-[2rem] p-5 text-white shadow-sm">
			<p class="text-center text-sm text-white/90 sm:text-base"><?php echo e(__('Investment balance')); ?></p>
			<div class="mt-2 flex items-center justify-center gap-3">
				<h2 class="text-xl font-extrabold tracking-tight sm:text-3xl">
					<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showBalance): ?>
						<?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'], 2)); ?>

					<?php else: ?>
						<?php echo e(__('******')); ?>

					<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
				</h2>
				<button type="button" wire:click="toggleBalanceVisibility"
					class="inline-flex h-10 w-10 items-center justify-center rounded-full border border-white/40 text-white transition hover:bg-white/10"
					aria-label="<?php echo e($showBalance ? __('Hide balance') : __('Show balance')); ?>">
					<i class="fa-solid <?php echo e($showBalance ? 'fa-eye-slash' : 'fa-eye'); ?> text-base sm:text-lg"></i>
				</button>
			</div>

			<div class="mt-5 grid grid-cols-2 gap-3 text-center">
				<div>
					<p class="text-xs text-white/90 sm:text-sm"><?php echo e(__('Interest earned yesterday')); ?></p>
					<p class="text-lg font-bold lowercase sm:text-xl"><?php echo e(__('n/a')); ?></p>
				</div>
				<div>
					<p class="text-xs text-white/90 sm:text-sm"><?php echo e(__('Net rate (last 24 hrs)')); ?></p>
					<p class="text-lg font-bold sm:text-xl">
						<?php echo e(number_format($this->annualNetRatePercent, 1)); ?>% p.a
					</p>
				</div>
			</div>

			<div class="mt-6 grid grid-cols-2 gap-4">
				<a href="<?php echo e(route($this->portfolio['balance'] > 0 ? 'member.investments' : 'member.mpesa-deposit')); ?>"
					wire:navigate
					class="inline-flex items-center justify-center gap-2 rounded-full bg-white px-4 py-2 text-sm font-bold text-brand-green transition hover:bg-white/90">
					<img src="<?php echo e(asset('media/images/invenst-icon-1.png')); ?>" alt="<?php echo e(__('Invest')); ?>" class="h-4 w-4 object-contain" />
					<span><?php echo e(__('Invest')); ?></span>
				</a>
				<a href="<?php echo e(route('member.withdraw')); ?>" wire:navigate
					class="inline-flex items-center justify-center gap-2 rounded-full border border-white/60 bg-transparent px-4 py-2 text-sm font-bold text-white transition hover:bg-white/10">
					<i class="fa-solid fa-hand-holding-dollar text-sm"></i>
					<span><?php echo e(__('Withdraw')); ?></span>
				</a>
			</div>
		</section>

		<div
			class="<?php echo e($this->isMarketOpen ? 'border-primary/30 bg-primary/10' : 'border-destructive/30 bg-destructive/10'); ?> rounded-xl border px-4 py-3">
			<div class="flex items-center gap-2">
				<i class="fa-solid fa-circle-info h-4 w-4 <?php echo e($this->isMarketOpen ? 'text-primary' : 'text-destructive'); ?>"></i>
				<span class="text-xs font-medium sm:text-sm <?php echo e($this->isMarketOpen ? 'text-primary' : 'text-destructive'); ?>">
					<?php echo e($this->isMarketOpen ? __('Market is open') : __('Market is closed for today.')); ?>

				</span>
			</div>
		</div>

		<section class="grid grid-cols-2 gap-3">
			<a href="<?php echo e(route('member.investments')); ?>" wire:navigate
				class="overflow-hidden rounded-2xl border border-[#F4D8AF]">
				<div class="bg-[#FFEACE] px-4 py-4 text-center">
					<img src="<?php echo e(asset('media/images/pad-lock-zidii.png')); ?>" alt="<?php echo e(__('Zidii Trade')); ?>"
						class="mx-auto h-10 w-10 object-contain">
				</div>
				<div class="bg-[#FFF4E6] px-4 py-3 text-center">
					<p class="text-sm font-semibold text-[#71706f] sm:text-base"><?php echo e(__('ZiiDi Lock')); ?></p>
					<p class="text-[11px] text-muted-foreground sm:text-xs"><?php echo e(__('Feeling spontaneous with your wealth? Lock it!')); ?></p>
				</div>
			</a>
			<a href="<?php echo e(route('member.investments')); ?>" wire:navigate
				class="overflow-hidden rounded-2xl border border-[#BCEAD0]">
				<div class="bg-[#CDF3DC] px-4 py-4 text-center">
					<img src="<?php echo e(asset('media/images/cash-bag-zidii.png')); ?>" alt="<?php echo e(__('Auto Invest')); ?>"
						class="mx-auto h-10 w-10 object-contain">
				</div>
				<div class="bg-[#EAF9F0] px-4 py-3 text-center">
					<p class="text-sm font-semibold text-[#71706f] sm:text-base"><?php echo e(__('Auto Invest')); ?></p>
					<p class="text-[11px] text-muted-foreground sm:text-xs"><?php echo e(__('Spend like a pro, invest like a champion')); ?></p>
				</div>
			</a>
		</section>

		<section class="space-y-2">
			<p class="text-xs font-semibold text-foreground sm:text-sm"><?php echo e(__('Transaction')); ?></p>
			<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
				<div class="flex items-center justify-between rounded-xl border border-border bg-card p-3">
					<div>
						<p class="text-xs font-semibold text-foreground sm:text-sm">
							<?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?></p>
						<p class="text-[11px] text-muted-foreground sm:text-xs"><?php echo e($transaction->created_at?->format('Y-m-d H:i')); ?></p>
					</div>
					<div class="text-right">
						<p class="text-xs font-semibold text-foreground sm:text-sm"><?php echo e($this->portfolio['currency']); ?>

							<?php echo e(number_format((float) $transaction->amount, 2)); ?></p>
						<?php ($normalizedStatus = strtolower((string) $transaction->status)); ?>
						<p
							class="text-[11px] text-muted-foreground transaction-status sm:text-xs <?php echo e($normalizedStatus === 'pending' ? 'transaction-status--pending' : (in_array($normalizedStatus, ['approved', 'completed'], true) ? 'transaction-status--approved' : '')); ?>">
							<?php echo e(ucfirst($transaction->status)); ?>

						</p>
					</div>
				</div>
			<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
				<p class="text-xs text-muted-foreground sm:text-sm"><?php echo e(__('No transactions yet.')); ?></p>
			<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

			<div class="pt-1">
				<a href="<?php echo e(route('member.transactions')); ?>" wire:navigate
					class="inline-flex items-center rounded-lg bg-[#2CB34A] px-3 py-2 text-xs font-semibold text-white transition hover:bg-[#24933d] sm:text-sm">
					<?php echo e(__('Show more')); ?>

				</a>
			</div>
		</section>
	</div>
</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/2cb8b7df.blade.php ENDPATH**/ ?>