<?php
use App\Facades\Vrm\MediaForge;
use App\Models\InvestmentPackage;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;
use Livewire\WithFileUploads;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Edit Investment Package')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Update package details. Changing min/max or interest does not affect existing subscriptions.')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('button', null, []); ?> 
            <a href="<?php echo e(route('admin.investment-packages.index')); ?>" wire:navigate
                class="bg-black dark:bg-gray-700 text-white hover:bg-gray-800 dark:hover:bg-gray-600 px-3 py-2 rounded-md float-right text-sm font-bold">
                <?php echo e(__('Go Back')); ?>

            </a>
         <?php $__env->endSlot(); ?>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg px-4 py-5 mb-5 sm:p-6">
            <?php echo $this->renderNotification(); ?>


            <form wire:submit="save" class="space-y-6">
                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Name')); ?></label>
                        <input type="text" wire:model="name"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('name')); ?></span>
                    </div>
                    <div class="grid grid-cols-2 gap-2">
                        <div>
                            <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Min amount')); ?></label>
                            <input type="number" step="0.01" min="0" wire:model="min_amount"
                                class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                            <span class="text-red-500 text-sm"><?php echo e($errors->first('min_amount')); ?></span>
                        </div>
                        <div>
                            <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Max amount')); ?></label>
                            <input type="number" step="0.01" min="0" wire:model="max_amount"
                                class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                            <span class="text-red-500 text-sm"><?php echo e($errors->first('max_amount')); ?></span>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Interest (%)')); ?></label>
                        <input type="number" step="0.01" min="0" wire:model="interest_percent"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('interest_percent')); ?></span>
                    </div>
                    <div>
                        <label class="required block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Duration (hours)')); ?></label>
                        <input type="number" min="1" wire:model="duration_hours"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('duration_hours')); ?></span>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Description')); ?></label>
                    <textarea wire:model="description" rows="3"
                        class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6"></textarea>
                    <span class="text-red-500 text-sm"><?php echo e($errors->first('description')); ?></span>
                </div>

                <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Photo (leave empty to keep current)')); ?></label>
                        <input type="file" wire:model="photo" accept=".jpg,.jpeg,.png,.webp"
                            class="mt-1 block w-full cursor-pointer px-3 py-2 text-sm file:mr-4 file:rounded-md file:border-0 file:bg-gray-200 dark:file:bg-gray-600 file:px-3 file:py-1.5 file:text-sm file:font-semibold file:text-gray-900 dark:file:text-gray-100" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('photo')); ?></span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($photo): ?>
                            <img src="<?php echo e($photo->temporaryUrl()); ?>" class="mt-2 h-24 w-24 rounded object-cover" alt="Preview" />
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Currency code')); ?></label>
                        <input type="text" wire:model="currency_code" maxlength="3" placeholder="e.g. USD"
                            class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 sm:text-sm/6" />
                        <span class="text-red-500 text-sm"><?php echo e($errors->first('currency_code')); ?></span>
                    </div>
                </div>

                <div class="flex items-center gap-2">
                    <input type="checkbox" wire:model="is_active" id="is_active" class="rounded border-gray-300 dark:border-gray-600" />
                    <label for="is_active" class="text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Active (visible to members)')); ?></label>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="rounded-md bg-indigo-600 px-4 py-2 text-sm font-semibold text-white hover:bg-indigo-500">
                        <?php echo e(__('Update Package')); ?>

                    </button>
                </div>
            </form>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/c559c2e2.blade.php ENDPATH**/ ?>