<?php
use App\Models\WalletTransaction;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Transactions')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('View all money in and out. Every wallet transaction is recorded here.')); ?> <?php $__env->endSlot(); ?>

        <div class="mb-4 flex flex-wrap items-end gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Type')); ?></label>
                <select wire:model.live="type"
                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $this->typeOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <option value="<?php echo e($t); ?>"><?php echo e($this->typeLabel($t)); ?></option>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></label>
                <select wire:model.live="status"
                    class="mt-1 block w-full rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                    <option value="all"><?php echo e(__('All')); ?></option>
                    <option value="pending"><?php echo e(__('Pending')); ?></option>
                    <option value="approved"><?php echo e(__('Approved')); ?></option>
                    <option value="rejected"><?php echo e(__('Rejected')); ?></option>
                    <option value="completed"><?php echo e(__('Completed')); ?></option>
                </select>
            </div>
        </div>

        <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
            <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Member')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Type')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Amount')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Currency')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Date')); ?></th>
                        <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Processed By')); ?></th>
                        <th class="py-3.5 pr-4 pl-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Description')); ?></th>
                        <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                            <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100"><?php echo e($tx->user?->name ?? '-'); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($this->typeLabel($tx->type)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(number_format((float) $tx->amount, 2)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($tx->currency_code); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(ucfirst($tx->status)); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-500 dark:text-gray-400"><?php echo e($tx->created_at?->format('M j, Y g:i A') ?? '-'); ?></td>
                            <td class="py-4 px-3 text-sm text-gray-500 dark:text-gray-400"><?php echo e($tx->approver?->name ?? '-'); ?></td>
                            <td class="py-4 pr-4 pl-3 text-sm text-gray-500 dark:text-gray-400 max-w-xs truncate" title="<?php echo e($tx->description); ?>"><?php echo e($tx->description ?? '-'); ?></td>
                            <td class="py-4 pr-4 pl-3 text-right">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tx->canDownloadReceipt()): ?>
                                    <a href="<?php echo e(route('admin.transactions.receipt.download', ['transaction' => $tx->id])); ?>"
                                        class="inline-flex items-center rounded-md border border-gray-300 px-2.5 py-1 text-xs font-semibold text-gray-700 hover:bg-gray-100 dark:border-gray-600 dark:text-gray-200 dark:hover:bg-gray-700">
                                        <?php echo e(__('Download Receipt')); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="text-xs text-gray-400"><?php echo e(__('N/A')); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                        </tr>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <tr>
                            <td colspan="9" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400"><?php echo e(__('No transactions found.')); ?></td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-4"><?php echo e($this->transactions->links()); ?></div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/24a5ac76.blade.php ENDPATH**/ ?>