<?php
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Services\LiveStockService;
use App\Services\Trading\TradingSettingsService;
use App\Models\Wallet;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'FX ZIDII'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('partials.trading.marquee', ['securities' => $this->securities], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="px-4 py-4 space-y-4">
        <div class="<?php echo e($this->isMarketOpen ? 'bg-primary/10 border border-primary/30' : 'bg-destructive/10 border border-destructive/30'); ?> flex items-center justify-between rounded-lg px-4 py-3">
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-circle-info h-4 w-4 <?php echo e($this->isMarketOpen ? 'text-primary' : 'text-destructive'); ?>"></i>
                <span class="text-sm font-medium <?php echo e($this->isMarketOpen ? 'text-primary' : 'text-destructive'); ?>">
                    <?php echo e($this->isMarketOpen ? __('Market is open') : __('Market is closed for today.')); ?>

                </span>
            </div>
        </div>

        <div class="bg-card rounded-xl p-5 border border-border">
            <p class="text-muted-foreground text-sm mb-1"><?php echo e(__('Your portfolio value')); ?></p>
            <h2 class="text-3xl font-bold text-foreground mb-3"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'], 2)); ?></h2>
            <div class="border-t border-border pt-3 flex items-center justify-between">
                <span class="text-muted-foreground text-sm"><?php echo e(__('Value')); ?> : <?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'] + $this->portfolio['inTrade'], 2)); ?></span>
                <span class="text-sm font-semibold px-4 py-1 rounded-full <?php echo e($this->portfolio['gainLoss'] >= 0 ? 'bg-primary text-primary-foreground' : 'bg-destructive text-destructive-foreground'); ?>">
                    <?php echo e($this->portfolio['gainLoss'] >= 0 ? '+' : ''); ?><?php echo e(number_format($this->portfolio['gainLoss'], 2)); ?>%
                </span>
            </div>
        </div>

        <div class="bg-card rounded-xl p-4 border border-border flex items-center justify-between">
            <div>
                <p class="text-muted-foreground text-xs"><?php echo e(__('Balance')); ?></p>
                <p class="text-foreground font-semibold"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['balance'], 2)); ?></p>
            </div>
            <div class="text-right">
                <p class="text-muted-foreground text-xs"><?php echo e(__('In Trade')); ?></p>
                <div class="flex items-center gap-2">
                    <p class="text-foreground font-semibold"><?php echo e($this->portfolio['currency']); ?> <?php echo e(number_format($this->portfolio['inTrade'], 2)); ?></p>
                    <span class="text-xs font-bold px-2 py-0.5 rounded-full <?php echo e($this->portfolio['gainLoss'] >= 0 ? 'bg-gain/20 text-gain' : 'bg-loss/20 text-loss'); ?>">
                        <?php echo e($this->portfolio['gainLoss'] >= 0 ? '+' : ''); ?><?php echo e(number_format($this->portfolio['gainLoss'], 2)); ?>%
                    </span>
                </div>
            </div>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->newestSecurity): ?>
            <div class="bg-card rounded-xl p-4 border border-primary/30 border-dashed">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-primary/20 rounded-full flex items-center justify-center">
                        <i class="fa-solid fa-arrow-trend-up h-5 w-5 text-primary"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-foreground text-sm">
                            <span class="font-semibold"><?php echo e($this->newestSecurity['name']); ?></span> <?php echo e(__('is now listed for trading')); ?>

                        </p>
                    </div>
                    <a href="<?php echo e(route('member.trade')); ?>" wire:navigate class="text-sm font-medium text-primary border border-primary rounded-lg px-3 py-1.5"><?php echo e(__('Go to Trade')); ?></a>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <div class="bg-card rounded-xl p-5 border border-border">
            <div class="flex items-center gap-2 mb-3">
                <i class="fa-solid fa-clock h-4 w-4 text-muted-foreground"></i>
                <h3 class="text-foreground font-semibold text-sm"><?php echo e(__('Pending Orders')); ?></h3>
            </div>
            <div class="bg-destructive/10 rounded-lg p-4 text-center">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->pendingOrdersCount > 0): ?>
                    <p class="text-foreground text-sm mb-3"><?php echo e(__('You have :count pending orders awaiting admin approval.', ['count' => $this->pendingOrdersCount])); ?></p>
                <?php else: ?>
                    <p class="text-foreground text-sm mb-3"><?php echo e(__('There are no pending orders yet, click the button to start!')); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <a href="<?php echo e(route('member.trade')); ?>" wire:navigate class="inline-block bg-primary text-primary-foreground font-semibold py-2.5 px-6 rounded-lg text-sm"><?php echo e(__('Go to trading')); ?></a>
            </div>
        </div>

        <div class="bg-card rounded-xl p-4 border border-border">
            <div class="flex items-center gap-2 mb-3">
                <i class="fa-solid fa-star h-4 w-4 text-primary"></i>
                <h3 class="text-foreground font-semibold text-sm"><?php echo e(__('Your Watchlist')); ?></h3>
            </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($this->watchlist) === 0): ?>
                <p class="text-muted-foreground text-sm text-center py-4"><?php echo e(__('Your watchlist is empty')); ?></p>
            <?php else: ?>
                <div class="space-y-3">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $this->watchlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <div class="flex items-center justify-between py-2" <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('watch-{{ $s[\'id\'] }}', get_defined_vars()); ?>wire:key="watch-<?php echo e($s['id']); ?>">
                            <div>
                                <p class="text-foreground font-semibold text-sm"><?php echo e($s['symbol']); ?></p>
                                <p class="text-muted-foreground text-xs"><?php echo e($s['name']); ?></p>
                            </div>
                            <div class="text-right">
                                <p class="text-foreground font-semibold text-sm"><?php echo e(number_format($s['price'], 2)); ?></p>
                                <p class="text-xs <?php echo e($s['change'] >= 0 ? 'text-gain' : 'text-loss'); ?>"><?php echo e($s['change'] >= 0 ? '▲' : '▼'); ?><?php echo e(number_format(abs($s['change']), 2)); ?>%</p>
                            </div>
                        </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <div class="fixed bottom-24 right-4 z-40 max-w-lg">
            <a href="<?php echo e(route('member.trade')); ?>" wire:navigate class="flex items-center gap-2 bg-primary text-primary-foreground font-semibold py-3 px-6 rounded-full shadow-lg hover:opacity-90 transition-opacity">
                <i class="fa-solid fa-cart-shopping h-5 w-5"></i>
                <?php echo e(__('Buy Stocks')); ?>

            </a>
        </div>
    </div>
</div><?php /**PATH /Users/cybertruck/DevProjects/2026/FxZidii/storage/framework/views/livewire/views/563ab22a.blade.php ENDPATH**/ ?>