<aside class="hidden lg:flex flex-col w-56 min-h-screen bg-card border-r border-border fixed left-0 top-0 z-50">
    <div class="flex items-center gap-2 px-6 py-6">
        <div class="w-9 h-9 bg-primary/20 rounded-lg flex items-center justify-center">
            <i class="fa-solid fa-chart-line h-5 w-5 text-primary"></i>
        </div>
        <span class="font-display text-xl font-bold text-foreground"><?php echo e(config('app.name')); ?></span>
    </div>
    <nav class="flex-1 flex flex-col gap-1 px-3 mt-4">
        <a href="<?php echo e(route('member.dashboard')); ?>" wire:navigate
            class="flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium transition-colors <?php echo e(request()->routeIs('member.dashboard') ? 'bg-primary/20 text-primary' : 'text-muted-foreground hover:bg-muted hover:text-foreground'); ?>">
            <i class="fa-solid fa-house h-5 w-5"></i>
            <?php echo e(__('Home')); ?>

        </a>
        <a href="<?php echo e(route('member.trade')); ?>" wire:navigate
            class="flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium transition-colors <?php echo e(request()->routeIs('member.trade') ? 'bg-primary/20 text-primary' : 'text-muted-foreground hover:bg-muted hover:text-foreground'); ?>">
            <i class="fa-solid fa-chart-line h-5 w-5"></i>
            <?php echo e(__('Trade')); ?>

        </a>
        <a href="<?php echo e(route('member.mpesa-deposit')); ?>" wire:navigate
            class="flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium transition-colors <?php echo e(request()->routeIs('member.mpesa-deposit') ? 'bg-primary/20 text-primary' : 'text-muted-foreground hover:bg-muted hover:text-foreground'); ?>">
            <i class="fa-solid fa-sack-dollar h-5 w-5"></i>
            <?php echo e(__('Deposit')); ?>

        </a>
        <a href="<?php echo e(route('member.portfolio')); ?>" wire:navigate
            class="flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium transition-colors <?php echo e(request()->routeIs('member.portfolio') ? 'bg-primary/20 text-primary' : 'text-muted-foreground hover:bg-muted hover:text-foreground'); ?>">
            <i class="fa-solid fa-chart-bar h-5 w-5"></i>
            <?php echo e(__('Portfolio')); ?>

        </a>
        <a href="<?php echo e(route('member.account')); ?>" wire:navigate
            class="flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium transition-colors <?php echo e(request()->routeIs('member.account') ? 'bg-primary/20 text-primary' : 'text-muted-foreground hover:bg-muted hover:text-foreground'); ?>">
            <i class="fa-solid fa-user h-5 w-5"></i>
            <?php echo e(__('Account')); ?>

        </a>
    </nav>
    <div class="px-3 pb-6">
        <a href="<?php echo e(route('logout')); ?>"
            class="flex items-center gap-3 px-4 py-3 rounded-lg text-sm font-medium text-muted-foreground hover:bg-muted hover:text-foreground transition-colors"
            onclick="event.preventDefault(); document.getElementById('logout-form-trading-sidebar').submit();">
            <i class="fa-solid fa-right-from-bracket h-5 w-5"></i>
            <?php echo e(__('Log out')); ?>

        </a>
        <form id="logout-form-trading-sidebar" action="<?php echo e(route('logout')); ?>" method="POST" class="hidden">
            <?php echo csrf_field(); ?>
        </form>
    </div>
</aside>
<?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/resources/views/partials/trading/desktop-sidebar.blade.php ENDPATH**/ ?>