<?php
use App\Models\InvestmentPackage;
use App\Models\WalletTransaction;
use App\Mail\AdminDepositMail;
use App\Mail\SubscriptionCreatedMail;
use App\Mail\WalletTransactionMail;
use App\Services\Investment\SubscriptionService;
use App\Services\Sms\SmsAfrikasTalking;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;
use Livewire\Attributes\Computed;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    <?php if (isset($component)) { $__componentOriginal3fb04b830347e2c9060ed87f2e59736f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f = $attributes; } ?>
<?php $component = App\View\Components\AdminPanel::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-panel'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminPanel::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

         <?php $__env->slot('header', null, []); ?> <?php echo e(__('Wallet Requests')); ?> <?php $__env->endSlot(); ?>
         <?php $__env->slot('desc', null, []); ?> <?php echo e(__('Approve or reject member deposit and withdrawal requests.')); ?> <?php $__env->endSlot(); ?>

        <?php echo $this->renderNotification(); ?>


        <div class="mb-4">
            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-100"><?php echo e(__('Status Filter')); ?></label>
            <select wire:model.live="status"
                class="mt-1 block w-full max-w-xs rounded-md bg-white dark:bg-gray-700 px-3 py-1.5 text-base text-gray-900 dark:text-gray-100 outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-600 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
                <option value="pending"><?php echo e(__('Pending')); ?></option>
                <option value="approved"><?php echo e(__('Approved')); ?></option>
                <option value="rejected"><?php echo e(__('Rejected')); ?></option>
                <option value="all"><?php echo e(__('All')); ?></option>
            </select>
        </div>

        
        <div class="mb-10">
            <h2 class="text-base font-semibold text-gray-900 dark:text-gray-100 mb-3"><?php echo e(__('Deposit Requests')); ?></h2>
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Name')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Phone Number')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Amount')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Transaction Code')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Date & Time')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></th>
                            <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->depositRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                                <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->user?->name ?? '-'); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->phone_number ?? data_get($request->meta, 'phone_number', $request->user?->phone) ?? '-'); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->currency_code); ?> <?php echo e(number_format((float) $request->amount, 2)); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->transaction_code ?? data_get($request->meta, 'reference') ?? '-'); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->created_at?->format('M j, Y g:i A') ?? '-'); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(ucfirst($request->status)); ?></td>
                                <td class="py-4 pr-4 pl-3 text-right">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($request->status === 'pending'): ?>
                                        <button type="button" wire:click="approve(<?php echo e($request->id); ?>)"
                                            class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500"><?php echo e(__('Approve')); ?></button>
                                        <button type="button" wire:click="reject(<?php echo e($request->id); ?>)"
                                            class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500"><?php echo e(__('Reject')); ?></button>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-500"><?php echo e(__('Processed')); ?></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                            </tr>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                            <tr>
                                <td colspan="7" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400"><?php echo e(__('No deposit requests found.')); ?></td>
                            </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-4"><?php echo e($this->depositRequests->links()); ?></div>
        </div>

        
        <div>
            <h2 class="text-base font-semibold text-gray-900 dark:text-gray-100 mb-3"><?php echo e(__('Withdrawal Requests')); ?></h2>
            <div class="overflow-hidden shadow-sm ring-1 ring-black/5 dark:ring-white/10 sm:rounded-lg">
                <table class="min-w-full divide-y divide-gray-300 dark:divide-gray-600">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="py-3.5 pr-3 pl-4 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Member')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Amount')); ?></th>
                            <th class="py-3.5 px-3 text-left text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Status')); ?></th>
                            <th class="py-3.5 pr-4 pl-3 text-right text-sm font-semibold text-gray-900 dark:text-gray-100"><?php echo e(__('Actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="bg-white dark:bg-gray-800">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->withdrawalRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                            <tr class="even:bg-gray-50 dark:even:bg-gray-800/50">
                                <td class="py-4 pr-3 pl-4 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->user?->name ?? '-'); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e($request->currency_code); ?> <?php echo e(number_format((float) $request->amount, 2)); ?></td>
                                <td class="py-4 px-3 text-sm text-gray-900 dark:text-gray-100"><?php echo e(ucfirst($request->status)); ?></td>
                                <td class="py-4 pr-4 pl-3 text-right">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($request->status === 'pending'): ?>
                                        <button type="button" wire:click="approve(<?php echo e($request->id); ?>)"
                                            class="inline-flex items-center rounded-md bg-green-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-green-500"><?php echo e(__('Approve')); ?></button>
                                        <button type="button" wire:click="reject(<?php echo e($request->id); ?>)"
                                            class="inline-flex items-center rounded-md bg-red-600 px-2.5 py-1 text-xs font-semibold text-white hover:bg-red-500"><?php echo e(__('Reject')); ?></button>
                                    <?php else: ?>
                                        <span class="text-xs text-gray-500"><?php echo e(__('Processed')); ?></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                            </tr>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                            <tr>
                                <td colspan="4" class="py-6 text-center text-sm text-gray-500 dark:text-gray-400"><?php echo e(__('No withdrawal requests found.')); ?></td>
                            </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="mt-4"><?php echo e($this->withdrawalRequests->links()); ?></div>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $attributes = $__attributesOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__attributesOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f)): ?>
<?php $component = $__componentOriginal3fb04b830347e2c9060ed87f2e59736f; ?>
<?php unset($__componentOriginal3fb04b830347e2c9060ed87f2e59736f); ?>
<?php endif; ?>
</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/083a3cb1.blade.php ENDPATH**/ ?>