<?php
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminDepositMail;
use App\Mail\WalletTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\MemberNotificationService;
use App\Services\Investment\SubscriptionService;
use App\Services\Trading\TradingSettingsService;
use App\Services\Sms\SmsNotifier;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Sleep;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	<div x-data="{ scrolled: false }" x-init="scrolled = window.scrollY > 6;
window.addEventListener('scroll', () => scrolled = window.scrollY > 6)"
		:class="scrolled ? 'bg-zinc-950 border-zinc-800' : 'bg-background border-border'"
		class="sticky top-0 z-40 border-b px-4 py-3 transition-colors duration-200">
		<div class="flex items-start justify-between gap-3">
			<a href="<?php echo e(route('member.dashboard')); ?>" wire:navigate class="mt-1 text-foreground">
				<i class="fa-solid fa-arrow-left text-base"></i>
			</a>
			<div class="flex-1">
				<p class="text-base font-semibold text-foreground"><?php echo e(__('Deposit Funds')); ?></p>
				<p class="text-sm text-muted-foreground"><?php echo e(__('Add funds to start investing')); ?></p>
			</div>
			<button type="button" class="mt-1 text-foreground" aria-label="<?php echo e(__('Help')); ?>">
				<i class="fa-regular fa-circle-question text-base"></i>
			</button>
		</div>
	</div>

	<div class="mx-auto w-full max-w-xl px-4 py-5 space-y-4">
		<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($this->notification)): ?>
			<div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
				x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
				x-transition:leave="transform transition ease-in duration-200"
				x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
				x-init="setTimeout(() => {
    show = false;
    $wire.clearNotification();
}, 3500)"
				class="fixed inset-x-0 bottom-24 z-[96] px-4 lg:bottom-6 [&_.toast]:mx-auto [&_.toast]:max-w-sm [&_.toast]:w-full">
				<?php echo $this->renderNotification(); ?>

			</div>
		<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

		<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($depositStep === 'form'): ?>
			<div class="bg-card rounded-2xl border border-border p-4 sm:p-5 space-y-4">
				<div class="rounded-xl border border-emerald-500/60 bg-primary/10 p-3.5">
					<div class="flex items-center gap-3">
						<div class="size-11 rounded-xl bg-emerald-600 text-white flex items-center justify-center text-md font-bold">M
						</div>
						<div>
							<p class="text-sm font-semibold text-foreground dark:text-white"><?php echo e(__('M-Pesa Instant Deposit')); ?></p>
							<p class="text-xs text-muted-foreground dark:text-white/90"><?php echo e(__('Fast & secure mobile money transfer')); ?></p>
						</div>
					</div>
				</div>

				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($intent === \App\Services\Investment\SubscriptionService::META_INTENT_SUBSCRIPTION): ?>
					<div class="rounded-xl border border-primary/30 bg-primary/10 px-3 py-2 text-xs text-primary">
						<?php echo e(__('Top up this amount to complete your package subscription after admin approval.')); ?>

					</div>
				<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

				<div class="space-y-2">
					<label class="block text-sm font-medium text-foreground"><?php echo e(__('Phone Number')); ?></label>
					<div class="relative">
						<i class="fa-solid fa-phone absolute left-4 top-1/2 -translate-y-1/2 text-sm text-muted-foreground"></i>
						<input type="text" wire:model="phoneNumber"
							maxlength="12"
							class="w-full rounded-xl border border-border bg-background py-2.5 pl-11 pr-4 text-sm text-foreground"
							placeholder="254712345678" />
					</div>
					<p class="text-xs text-muted-foreground"><?php echo e(__('Enter your M-Pesa registered phone number starting with 254 (e.g. 254712345678).')); ?>

					</p>
					<span class="text-destructive text-xs"><?php echo e($errors->first('phoneNumber')); ?></span>
				</div>

				<div class="space-y-2">
					<label class="block text-sm font-medium text-foreground"><?php echo e(__('Amount (Ksh)')); ?></label>
					<input type="number" step="0.01" min="<?php echo e($this->depositLimits['min']); ?>" <?php if($this->depositLimits['max'] < PHP_FLOAT_MAX): ?> max="<?php echo e($this->depositLimits['max']); ?>" <?php endif; ?> wire:model="amount"
						class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm text-foreground"
						placeholder="0.00" />
					<p class="text-xs text-muted-foreground">
						<?php echo e(__('Min: :min', ['min' => number_format($this->depositLimits['min'], 2)])); ?>

						<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($this->depositLimits['max'] < PHP_FLOAT_MAX): ?>
							<?php echo e(__('Max: :max', ['max' => number_format($this->depositLimits['max'], 2)])); ?>

						<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
					</p>
					<span class="text-destructive text-xs"><?php echo e($errors->first('amount')); ?></span>
				</div>

				<button type="button" wire:click="submitDepositRequest" wire:loading.attr="disabled"
					class="w-full rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-black disabled:cursor-not-allowed disabled:opacity-80">
					<span wire:loading.remove wire:target="submitDepositRequest"><?php echo e(__('Deposit with M-Pesa')); ?></span>
					<span wire:loading wire:target="submitDepositRequest" class="inline-flex items-center gap-2">
						<i class="fa-solid fa-spinner animate-spin text-sm"></i>
						<?php echo e(__('Sending Request')); ?>

					</span>
				</button>

				<div class="flex items-center justify-center gap-5 text-xs text-muted-foreground">
					<span><i class="fa-solid fa-shield mr-1"></i><?php echo e(__('Secure')); ?></span>
					<span><i class="fa-solid fa-bolt mr-1"></i><?php echo e(__('Instant')); ?></span>
					<span><i class="fa-regular fa-circle-check mr-1"></i><?php echo e(__('No Fees')); ?></span>
				</div>
			</div>
		<?php else: ?>
			<div class="bg-card rounded-2xl border border-border p-5 sm:p-6 min-h-[52vh] flex flex-col">
				<div class="pt-3 space-y-4 text-center mb-4">
					<div class="mx-auto size-16 rounded-full bg-green-600 text-white flex items-center justify-center">
						<i class="fa-solid fa-circle-check text-2xl"></i>
					</div>
					<p class="text-lg font-bold text-foreground"><?php echo e(__('Payment Request Sent')); ?></p>
				</div>

				<div class="my-auto space-y-6 rounded-xl border border-border bg-background p-5 mb-4">
					<p class="text-sm text-foreground">
						<?php echo e(__('Check your phone (:phone) and enter your M-Pesa PIN to complete the deposit of :amount.', ['phone' => $this->phoneNumber, 'amount' => number_format($submittedDepositAmount, 2)])); ?>

					</p>
					<p class="text-sm font-semibold text-foreground">
						<?php echo e(__('This request expires in 60 seconds.')); ?>

					</p>
				</div>

				<div class="mt-auto grid grid-cols-2 gap-3">
					<button type="button" wire:click="resetDepositFlow"
						class="w-full rounded-xl bg-muted px-4 py-2.5 text-sm font-semibold text-muted-foreground">
						<?php echo e(__('Cancel')); ?>

					</button>
					<button type="button" wire:click="completePayment"
						class="w-full rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-black">
						<?php echo e(__('I\'ve Completed Payment')); ?>

					</button>
				</div>
			</div>
		<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
	</div>
</div><?php /**PATH /home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/5f8b2ae0.blade.php ENDPATH**/ ?>