<?php
use App\Models\PortfolioHolding;
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Models\SecurityWatchlist;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Mail\AdminTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\Sms\SmsAfrikasTalking;
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    <?php echo $__env->make('partials.trading.topbar', ['title' => 'TRADE'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="px-4 space-y-4">
        <?php echo $this->renderNotification(); ?>


        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tradeStep === 'browse'): ?>
            <div class="bg-card rounded-lg p-3 border border-border text-sm text-foreground">
                <?php echo e(__('Available Balance')); ?>: <?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->wallet->available_balance, 2)); ?>

            </div>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(! $this->isMarketOpen): ?>
                <div class="rounded-lg border border-destructive/50 bg-destructive/10 px-3 py-2 text-sm text-destructive">
                    <?php echo e(__('Market is closed for today.')); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <div class="relative">
                <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 h-5 w-5 text-muted-foreground"></i>
                <input
                    type="text"
                    wire:model.live.debounce.300ms="search"
                    placeholder="<?php echo e(__('What are you looking for today?')); ?>"
                    class="w-full bg-card border border-border rounded-lg py-3 pl-11 pr-4 text-foreground placeholder:text-muted-foreground focus:outline-none focus:ring-2 focus:ring-primary"
                />
            </div>

            <div>
                <h2 class="text-foreground font-semibold mb-3"><?php echo e($showWatchlist ? __('My Watchlist') : __('Available Securities')); ?></h2>
            </div>

            <div class="space-y-2">
                <?php
                    $displayList = $showWatchlist ? $this->watchlistSecurities : $this->filteredSecurities;
                ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $displayList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $security): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <?php
                        $securityId = (int) ($security['id'] ?? 0);
                        $symbol = (string) ($security['symbol'] ?? '');
                        $name = (string) ($security['name'] ?? '');
                        $change = (float) ($security['change'] ?? 0);
                        $price = (float) ($security['price'] ?? 0);
                        $initials = (string) ($security['initials'] ?? substr($symbol !== '' ? $symbol : 'ST', 0, 2));
                        $isTradable = $securityId > 0;
                        $isInvested = $isTradable && in_array($securityId, $this->investedSecurityIds, true);
                    ?>
                    <div
                        <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('trade-{{ $securityId ?: $symbol }}', get_defined_vars()); ?>wire:key="trade-<?php echo e($securityId ?: $symbol); ?>"
                        <?php if($isTradable): ?> wire:click="startBuyFlow(<?php echo e($securityId); ?>)" <?php endif; ?>
                        class="w-full bg-card rounded-xl px-3 py-3 border border-border <?php echo e($isTradable ? 'cursor-pointer transition hover:border-primary/50' : ''); ?>"
                    >
                        <div class="flex items-center justify-between gap-3">
                            <div class="flex items-center gap-3 min-w-0">
                                <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0 overflow-hidden">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($security['logo'])): ?>
                                        <img src="<?php echo e(asset($security['logo'])); ?>" alt="" class="size-10 rounded-full object-cover" />
                                    <?php else: ?>
                                        <span class="text-xs font-bold text-foreground"><?php echo e(strtoupper(substr($initials, 0, 2))); ?></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div class="min-w-0">
                                    <div class="flex items-center gap-2">
                                        <p class="text-foreground font-bold text-sm"><?php echo e($symbol !== '' ? $symbol : strtoupper($initials)); ?></p>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($isInvested): ?>
                                            <span class="inline-flex items-center rounded-full bg-primary/15 px-2 py-0.5 text-[10px] font-semibold text-primary">
                                                <?php echo e(__('Invested')); ?>

                                            </span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <p class="text-muted-foreground text-xs truncate"><?php echo e($name); ?></p>
                                </div>
                            </div>
                            <div class="text-right shrink-0">
                                <p class="text-foreground font-bold text-sm"><?php echo e($this->currencyCode); ?> <?php echo e(number_format($price, 2)); ?></p>
                                <span class="text-xs font-medium <?php echo e($change >= 0 ? 'text-gain' : 'text-loss'); ?>">
                                    <?php echo e($change >= 0 ? '▲' : '▼'); ?><?php echo e(number_format(abs($change), 2)); ?>%
                                </span>
                            </div>
                        </div>
                    </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                    <p class="text-center text-sm text-muted-foreground py-6"><?php echo e(__('No securities available.')); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php elseif($tradeAction === 'buy' && $this->selectedSecurity): ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tradeStep === 'amount'): ?>
                <div class="bg-card rounded-xl border border-border p-4 space-y-4">
                    <p class="text-sm font-semibold text-foreground"><?php echo e(__('Buy :symbol', ['symbol' => $this->selectedSecurity->trading_name])); ?></p>
                    <p class="text-xs text-muted-foreground"><?php echo e(__('Price per share')); ?>: <?php echo e($this->currencyCode); ?> <?php echo e(number_format($this->selectedSecurity->latestPrice(), 2)); ?></p>
                    <div>
                        <label class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Amount to Invest')); ?></label>
                        <input type="number" min="0.01" step="0.01" wire:model.live.debounce.250ms="tradeAmount" class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
                        <p class="mt-1 text-xs text-muted-foreground"><?php echo e(__('Estimated shares')); ?>: <?php echo e($this->estimatedTradeShares()); ?></p>
                    </div>
                    <div class="grid grid-cols-2 gap-2">
                        <button type="button" wire:click="finishTradeFlow" class="w-full rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground"><?php echo e(__('Back')); ?></button>
                        <button type="button" wire:click="goToTradeConfirmation" class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Continue')); ?></button>
                    </div>
                </div>
            <?php elseif($tradeStep === 'confirm'): ?>
                <div class="bg-card rounded-xl border border-border p-4 space-y-4">
                    <p class="text-sm font-semibold text-foreground"><?php echo e(__('Confirm Buy Request')); ?></p>
                    <div class="space-y-1 text-sm">
                        <p class="text-foreground font-semibold"><?php echo e($this->selectedSecurity->trading_name); ?></p>
                        <p class="text-muted-foreground"><?php echo e(__('Amount')); ?>: <?php echo e($this->currencyCode); ?> <?php echo e(number_format((float) $tradeAmount, 2)); ?></p>
                        <p class="text-muted-foreground"><?php echo e(__('Estimated shares')); ?>: <?php echo e($this->estimatedTradeShares()); ?></p>
                    </div>
                    <div class="grid grid-cols-2 gap-2">
                        <button type="button" wire:click="backToTradeAmount" class="w-full rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground"><?php echo e(__('Edit')); ?></button>
                        <button type="button" wire:click="submitTradeRequest" class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Confirm')); ?></button>
                    </div>
                </div>
            <?php elseif($tradeStep === 'result'): ?>
                <div class="bg-card rounded-xl border border-border p-4 space-y-4 text-center">
                    <div class="mx-auto size-12 rounded-full bg-primary text-primary-foreground flex items-center justify-center">
                        <i class="fa-solid fa-check"></i>
                    </div>
                    <p class="text-sm font-semibold text-foreground"><?php echo e(__('Buy Request Submitted')); ?></p>
                    <p class="text-sm text-muted-foreground"><?php echo e(__('The request will be completed.')); ?></p>
                    <p class="text-xs text-muted-foreground"><?php echo e($tradeResultSymbol); ?> • <?php echo e(__('Qty')); ?>: <?php echo e($tradeResultQuantity); ?> • <?php echo e($this->currencyCode); ?> <?php echo e(number_format($tradeResultTotalAmount, 2)); ?></p>
                    <button type="button" wire:click="finishTradeFlow" class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Done')); ?></button>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tradeStep === 'browse'): ?>
        <div class="fixed bottom-24 right-4 z-40">
            <button
                type="button"
                wire:click="toggleWatchlist"
                class="flex items-center gap-2 bg-primary text-primary-foreground font-semibold py-3 px-5 rounded-full shadow-lg hover:opacity-90 transition-opacity"
            >
                <i class="fa-solid fa-star h-5 w-5"></i>
                <?php echo e(__('My Watchlist')); ?>

            </button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div><?php /**PATH /home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/c27d313a.blade.php ENDPATH**/ ?>