<?php
use App\Concerns\PasswordValidationRules;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminTransactionMail;
use App\Mail\PasswordUpdatedMail;
use App\Mail\WalletTransactionMail;
use App\Models\Investment;
use App\Models\PortfolioHolding;
use App\Models\SecurityOrder;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use App\Services\Sms\SmsNotifier;
use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	<?php echo $__env->make('partials.trading.topbar', ['title' => 'ACCOUNT'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

	<div class="px-4 space-y-4">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($this->sellFinalToast)): ?>
            <div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
                x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
                x-transition:leave="transform transition ease-in duration-200"
                x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
                x-init="setTimeout(() => {
    show = false;
    $wire.clearSellFinalToast();
}, 3500)"
                class="fixed inset-x-0 bottom-24 z-[97] px-4 lg:bottom-6">
                <div class="toast relative mx-auto w-full max-w-sm overflow-hidden rounded-lg border border-green-300"
                    role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="toast-header flex items-center justify-between gap-2 bg-green-50 px-2.5 py-1.5 text-green-800">
                        <div class="flex items-center gap-2">
                            <span
                                class="inline-flex h-4 w-4 shrink-0 items-center justify-center rounded-full bg-green-100 text-green-700">✓</span>
                            <strong class="mr-auto text-xs font-semibold"><?php echo e($this->sellFinalToast['title']); ?></strong>
                        </div>
                    </div>
                    <div class="toast-body border-t border-green-300 bg-green-50 px-2.5 py-2 text-xs text-green-800">
                        <?php echo e($this->sellFinalToast['description']); ?>

                    </div>
                </div>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($this->notification)): ?>
            <div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
                x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
                x-transition:leave="transform transition ease-in duration-200"
                x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
                x-init="setTimeout(() => {
    show = false;
    $wire.clearNotification();
}, 3500)"
                class="fixed inset-x-0 bottom-24 z-[96] px-4 lg:bottom-6 [&_.toast]:mx-auto [&_.toast]:max-w-sm [&_.toast]:w-full">
                <?php echo $this->renderNotification(); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

		<div class="flex flex-col items-center py-6">
			<div class="w-20 h-20 bg-secondary rounded-full flex items-center justify-center mb-3">
				<i class="fa-solid fa-user h-10 w-10 text-muted-foreground"></i>
			</div>
			<h2 class="text-foreground font-bold text-lg"><?php echo e(auth()->user()->name); ?></h2>
			<p class="text-muted-foreground text-sm"><?php echo e(auth()->user()->email); ?></p>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-2">
			<p class="text-sm text-muted-foreground"><?php echo e(__('Wallet (Available Cash)')); ?></p>
			<p class="text-lg font-bold text-foreground"><?php echo e($this->currencyCode); ?>

				<?php echo e(number_format($this->wallet->available_balance, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('Ledger Balance')); ?>: <?php echo e($this->currencyCode); ?>

				<?php echo e(number_format((float) $this->wallet->balance, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('Pending Trades')); ?>: <?php echo e($this->currencyCode); ?>

				<?php echo e(number_format((float) $this->wallet->used_amount, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('Pending Withdrawal')); ?>: <?php echo e($this->currencyCode); ?>

				<?php echo e(number_format($this->pendingWithdrawalAmount, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('Locked in Stocks (until sell)')); ?>: <?php echo e($this->currencyCode); ?>

				<?php echo e(number_format($this->stocksLockedAmount, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('Locked in Investments (until claim)')); ?>: <?php echo e($this->currencyCode); ?>

				<?php echo e(number_format($this->subscriptionsLockedAmount, 2)); ?></p>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Deposit Request')); ?></p>
			<a href="<?php echo e(route('member.mpesa-deposit')); ?>" wire:navigate
				class="inline-flex w-full items-center justify-center rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
				<?php echo e(__('Deposit Funds')); ?>

			</a>
		</div>

		<a href="<?php echo e(route('member.withdraw')); ?>" wire:navigate
			class="w-full bg-card rounded-xl p-4 border border-border flex items-center gap-4 text-left hover:border-primary/30 transition-colors">
			<div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0">
				<i class="fa-solid fa-money-bill-transfer h-5 w-5 text-primary"></i>
			</div>
			<div class="flex-1 min-w-0">
				<p class="text-foreground font-semibold text-sm"><?php echo e(__('Withdraw Funds')); ?></p>
				<p class="text-muted-foreground text-xs"><?php echo e(__('Withdraw via M-Pesa or bank transfer')); ?></p>
			</div>
			<i class="fa-solid fa-chevron-right h-5 w-5 text-muted-foreground shrink-0"></i>
		</a>

		<a href="<?php echo e(route('member.investments')); ?>" wire:navigate
			class="w-full bg-card rounded-xl p-4 border border-border flex items-center gap-4 text-left hover:border-primary/30 transition-colors">
			<div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0">
				<i class="fa-solid fa-sack-dollar h-5 w-5 text-primary"></i>
			</div>
			<div class="flex-1 min-w-0">
				<p class="text-foreground font-semibold text-sm"><?php echo e(__('Investments')); ?></p>
				<p class="text-muted-foreground text-xs"><?php echo e(__('Invest and claim fixed 2x returns after maturity')); ?></p>
			</div>
			<i class="fa-solid fa-chevron-right h-5 w-5 text-muted-foreground shrink-0"></i>
		</a>

		<div class="space-y-4">
            <a href="<?php echo e(route('member.portfolio')); ?>" wire:navigate
                class="w-full bg-card rounded-xl p-4 border border-border flex items-center gap-4 text-left hover:border-primary/30 transition-colors">
                <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0">
                    <i class="fa-solid fa-chart-line h-5 w-5 text-primary"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="text-foreground font-semibold text-sm"><?php echo e(__('Portfolio Performance')); ?></p>
                    <p class="text-muted-foreground text-xs"><?php echo e(__('View overall performance of all investments')); ?></p>
                </div>
                <i class="fa-solid fa-chevron-right h-5 w-5 text-muted-foreground shrink-0"></i>
            </a>

			<div class="space-y-2">
				<p class="text-sm font-semibold text-foreground"><?php echo e(__('Recent Withdrawals')); ?></p>
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->withdrawalTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
					<div class="bg-card rounded-xl p-3 border border-border flex items-center justify-between">
						<div>
							<p class="text-sm font-semibold text-foreground"><?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?></p>
							<p class="text-xs text-muted-foreground"><?php echo e($transaction->created_at?->format('Y-m-d H:i')); ?></p>
						</div>
						<div class="text-right">
							<p class="text-sm font-semibold text-foreground"><?php echo e($this->currencyCode); ?>

								<?php echo e(number_format((float) $transaction->amount, 2)); ?></p>
							<?php ($normalizedStatus = strtolower((string) $transaction->status)); ?>
							<p
								class="text-xs text-muted-foreground transaction-status <?php echo e($normalizedStatus === 'pending' ? 'transaction-status--pending' : ($normalizedStatus === 'rejected' ? 'transaction-status--rejected' : (in_array($normalizedStatus, ['approved', 'completed'], true) ? 'transaction-status--approved' : ''))); ?>">
								<?php echo e(ucfirst($transaction->status)); ?>

							</p>
						</div>
					</div>
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
					<p class="text-sm text-muted-foreground"><?php echo e(__('No withdrawal requests yet.')); ?></p>
				<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>

			<div class="space-y-2">
				<p class="text-sm font-semibold text-foreground"><?php echo e(__('Recent Trade')); ?></p>
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->tradeTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
					<div class="bg-card rounded-xl p-3 border border-border flex items-center justify-between">
						<div>
							<p class="text-sm font-semibold text-foreground"><?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?></p>
							<p class="text-xs text-muted-foreground"><?php echo e($transaction->created_at?->format('Y-m-d H:i')); ?></p>
						</div>
						<div class="text-right">
							<p class="text-sm font-semibold text-foreground"><?php echo e($this->currencyCode); ?>

								<?php echo e(number_format((float) $transaction->amount, 2)); ?></p>
							<?php ($normalizedStatus = strtolower((string) $transaction->status)); ?>
							<p
								class="text-xs text-muted-foreground transaction-status <?php echo e($normalizedStatus === 'pending' ? 'transaction-status--pending' : ($normalizedStatus === 'rejected' ? 'transaction-status--rejected' : (in_array($normalizedStatus, ['approved', 'completed'], true) ? 'transaction-status--approved' : ''))); ?>">
								<?php echo e(ucfirst($transaction->status)); ?>

							</p>
						</div>
					</div>
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
					<p class="text-sm text-muted-foreground"><?php echo e(__('No trade transactions yet.')); ?></p>
				<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>

			<div class="space-y-2">
				<p class="text-sm font-semibold text-foreground"><?php echo e(__('Recent Investment')); ?></p>
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->investmentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
					<div class="bg-card rounded-xl p-3 border border-border flex items-center justify-between">
						<div>
							<p class="text-sm font-semibold text-foreground"><?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?></p>
							<p class="text-xs text-muted-foreground"><?php echo e($transaction->created_at?->format('Y-m-d H:i')); ?></p>
						</div>
						<div class="text-right">
							<p class="text-sm font-semibold text-foreground"><?php echo e($this->currencyCode); ?>

								<?php echo e(number_format((float) $transaction->amount, 2)); ?></p>
							<?php ($normalizedStatus = strtolower((string) $transaction->status)); ?>
							<p
								class="text-xs text-muted-foreground transaction-status <?php echo e($normalizedStatus === 'pending' ? 'transaction-status--pending' : ($normalizedStatus === 'rejected' ? 'transaction-status--rejected' : (in_array($normalizedStatus, ['approved', 'completed'], true) ? 'transaction-status--approved' : ''))); ?>">
								<?php echo e(ucfirst($transaction->status)); ?>

							</p>
						</div>
					</div>
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
					<p class="text-sm text-muted-foreground"><?php echo e(__('No investment transactions yet.')); ?></p>
				<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>

		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Personal Information')); ?></p>
			<div>
				<label for="account_name" class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Name')); ?></label>
				<input id="account_name" type="text" wire:model="name" readonly
					class="w-full rounded-md border border-border bg-muted/30 px-3 py-2 text-sm text-foreground cursor-not-allowed" />
			</div>
			<div>
				<label for="account_email" class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Email')); ?></label>
				<input id="account_email" type="email" wire:model="email" readonly
					class="w-full rounded-md border border-border bg-muted/30 px-3 py-2 text-sm text-foreground cursor-not-allowed" />
			</div>
			<div>
				<label for="account_phone"
					class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Phone number')); ?></label>
				<input id="account_phone" type="tel" wire:model="phone" readonly
					class="w-full rounded-md border border-border bg-muted/30 px-3 py-2 text-sm text-foreground cursor-not-allowed"
					placeholder="<?php echo e(__('e.g. 254712345678')); ?>" />
			</div>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Password & Security')); ?></p>
			<div>
				<label for="account_current_password"
					class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Current Password')); ?></label>
				<input id="account_current_password" type="password" wire:model="current_password"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground"
					autocomplete="current-password" />
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-destructive text-xs"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>
			<div>
				<label for="account_password"
					class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('New Password')); ?></label>
				<input id="account_password" type="password" wire:model="password"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground"
					autocomplete="new-password" />
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-destructive text-xs"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>
			<div>
				<label for="account_password_confirmation"
					class="block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Confirm New Password')); ?></label>
				<input id="account_password_confirmation" type="password" wire:model="password_confirmation"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground"
					autocomplete="new-password" />
			</div>
			<button type="button" wire:click="updatePassword"
				class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
				<?php echo e(__('Update Password')); ?>

			</button>
		</div>

		<form method="POST" action="<?php echo e(route('logout')); ?>" class="contents" id="logout-form-account">
			<?php echo csrf_field(); ?>
			<button type="submit"
				class="w-full rounded-md border border-border bg-background px-4 py-2 text-sm font-semibold text-foreground hover:bg-muted/50 transition-colors">
				<?php echo e(__('Log out')); ?>

			</button>
		</form>
	</div>

</div><?php /**PATH /home/ziidiaik/home.ziiditrader.com/storage/framework/views/livewire/views/b5ab242b.blade.php ENDPATH**/ ?>