<?php
    $displayDate = $occurredAt ?: now()->format('jS M Y g:i A');
    $displayReference = $reference ?: 'N/A';
    $displayPhone = $phoneNumber ?: 'N/A';
    $digits = preg_replace('/\D+/', '', (string) $displayPhone);
    $maskedPhone = $displayPhone;
    if (is_string($displayPhone) && $displayPhone !== '' && strlen($digits) >= 7) {
        $maskedPhone = substr($digits, 0, 4) . '***' . substr($digits, -3);
    }
    $paymentType = ucfirst(str_replace('_', ' ', (string) $typeLabel));
    $logoUrl = $logoUrl ?? (rtrim((string) config('app.url'), '/') . '/media/zidii/assets/img/ziidi3.png');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ziidi Trader Transaction Receipt</title>
</head>
<body style="margin:0;padding:0;background:#e5e7eb;font-family:Arial,Helvetica,sans-serif;color:#1f2937;">
<table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="background:#e5e7eb;padding:24px 0;">
    <tr>
        <td align="center">
            <table role="presentation" width="520" cellspacing="0" cellpadding="0" style="max-width:520px;width:100%;background:#ffffff;border:1px solid #d1d5db;border-radius:12px;overflow:hidden;">
                
                <tr>
                    <td style="background:#2db548;padding:24px 32px;">
                        <img src="<?php echo e($logoUrl); ?>" alt="Ziidi Trader" width="120" height="36" style="height:36px;width:auto;object-fit:contain;filter:brightness(0) invert(1);" />
                    </td>
                </tr>
                
                <tr>
                    <td style="padding:32px;">
                        <h2 style="margin:0 0 8px;font-size:20px;font-weight:700;color:#1f2937;">Hi <?php echo e($recipientName); ?>,</h2>
                        <p style="margin:0;font-size:14px;color:#6b7280;line-height:1.5;">Thank you for making your payment with Ziidi Trader.</p>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($customMessage)): ?>
                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="margin-top:16px;background:#f3f4f6;border:1px solid #e5e7eb;border-radius:8px;">
                            <tr>
                                <td style="padding:16px;">
                                    <p style="margin:0;font-size:14px;color:#1f2937;line-height:1.5;white-space:pre-wrap;"><?php echo e($customMessage); ?></p>
                                </td>
                            </tr>
                        </table>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        
                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="margin-top:24px;border:1px solid #e5e7eb;border-radius:8px;overflow:hidden;">
                            <tr>
                                <td style="background:#2db548;padding:20px;">
                                    <p style="margin:0;font-size:12px;font-weight:500;color:rgba(255,255,255,0.9);">Total Amount Paid</p>
                                    <p style="margin:4px 0 0;font-size:24px;font-weight:700;color:#ffffff;"><?php echo e($currencyCode); ?> <?php echo e(number_format((float) $amount, 2)); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding:20px;">
                                    <table role="presentation" width="100%" cellspacing="0" cellpadding="0">
                                        <tr><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:12px;color:#6b7280;">Date</td><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:14px;font-weight:600;color:#1f2937;text-align:right;"><?php echo e($displayDate); ?></td></tr>
                                        <tr><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:12px;color:#6b7280;">Received From</td><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:14px;font-weight:600;color:#1f2937;text-align:right;"><?php echo e($recipientName); ?></td></tr>
                                        <tr><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:12px;color:#6b7280;">Transaction No</td><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:14px;font-weight:600;color:#1f2937;text-align:right;"><?php echo e($displayReference); ?></td></tr>
                                        <tr><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:12px;color:#6b7280;">Payment Type</td><td style="padding:8px 0;border-bottom:1px solid #f3f4f6;font-size:14px;font-weight:600;color:#1f2937;text-align:right;"><?php echo e($paymentType); ?></td></tr>
                                        <tr><td style="padding:8px 0;font-size:12px;color:#6b7280;">Phone Number</td><td style="padding:8px 0;font-size:14px;font-weight:600;color:#1f2937;text-align:right;"><?php echo e($maskedPhone); ?></td></tr>
                                    </table>
                                </td>
                            </tr>
                        </table>

                        <p style="margin:24px 0 0;font-size:12px;color:#6b7280;text-align:center;">If you have any questions, please contact our support team.</p>
                    </td>
                </tr>
                
                <tr>
                    <td style="padding:20px 32px;border-top:1px solid #e5e7eb;background:rgba(243,244,246,0.5);">
                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0">
                            <tr>
                                <td><img src="<?php echo e($logoUrl); ?>" alt="Ziidi Trader" width="80" height="24" style="height:24px;width:auto;object-fit:contain;" /></td>
                                <td style="text-align:right;font-size:10px;color:#6b7280;">Powered by M-PESA</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</body>
</html>
<?php /**PATH /home/ziidfelj/home.ziidi.trade/resources/views/emails/receipts/wallet-transaction.blade.php ENDPATH**/ ?>