<?php
use App\Concerns\PasswordValidationRules;
use App\Concerns\ProfileValidationRules;
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Notifications\PasswordUpdatedNotification;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Facades\Hash;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	<?php echo $__env->make('partials.trading.topbar', ['title' => 'ACCOUNT'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

	<div class="px-4 space-y-4">
		<?php echo $this->renderNotification(); ?>


		<iframe src="https://live.mystocks.co.ke/ticker/tape$" height="30" width="100%" frameborder="0" scrolling="no"
			spellcheck="false"></iframe>

		<div class="flex flex-col items-center py-6">
			<div class="w-20 h-20 bg-secondary rounded-full flex items-center justify-center mb-3">
				<i class="fa-solid fa-user h-10 w-10 text-muted-foreground"></i>
			</div>
			<h2 class="text-foreground font-bold text-lg"><?php echo e(auth()->user()->name); ?></h2>
			<p class="text-muted-foreground text-sm"><?php echo e(auth()->user()->email); ?></p>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-2">
			<p class="text-sm text-muted-foreground"><?php echo e(__('Wallet')); ?></p>
			<p class="text-xl font-bold text-foreground"><?php echo e($this->wallet->currency_code); ?>

				<?php echo e(number_format((float) $this->wallet->balance, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('Available')); ?>: <?php echo e($this->wallet->currency_code); ?>

				<?php echo e(number_format($this->wallet->available_balance, 2)); ?></p>
			<p class="text-sm text-muted-foreground"><?php echo e(__('In Trade')); ?>: <?php echo e($this->wallet->currency_code); ?>

				<?php echo e(number_format((float) $this->wallet->used_amount, 2)); ?></p>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Deposit Funds')); ?></p>
			<div class="flex items-center gap-2">
				<input type="number" step="0.01" min="0.01" wire:model="depositAmount"
					class="flex-1 rounded-md border border-border px-3 py-2" placeholder="0.00" />
				<button type="button" wire:click="deposit"
					class="rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground"><?php echo e(__('Deposit')); ?></button>
			</div>
            <a href="<?php echo e(route('member.mpesa-deposit')); ?>" wire:navigate
                class="block text-center rounded-md border border-primary px-4 py-2 text-sm font-semibold text-primary">
                <?php echo e(__('Deposit via M-Pesa')); ?>

            </a>
		</div>

        <a href="<?php echo e(route('member.investments')); ?>" wire:navigate
            class="w-full bg-card rounded-xl p-4 border border-border flex items-center gap-4 text-left hover:border-primary/30 transition-colors">
            <div class="w-10 h-10 bg-secondary rounded-full flex items-center justify-center shrink-0">
                <i class="fa-solid fa-sack-dollar h-5 w-5 text-primary"></i>
            </div>
            <div class="flex-1 min-w-0">
                <p class="text-foreground font-semibold text-sm"><?php echo e(__('Investments')); ?></p>
                <p class="text-muted-foreground text-xs"><?php echo e(__('Invest and claim fixed 2x returns after maturity')); ?></p>
            </div>
            <i class="fa-solid fa-chevron-right h-5 w-5 text-muted-foreground shrink-0"></i>
        </a>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Withdraw Funds')); ?></p>
			<div class="flex items-center gap-2">
				<input type="number" step="0.01" min="0.01" wire:model="withdrawAmount"
					class="flex-1 rounded-md border border-border px-3 py-2" placeholder="0.00" />
				<button type="button" wire:click="withdraw"
					class="rounded-md bg-destructive px-4 py-2 text-sm font-semibold text-destructive-foreground"><?php echo e(__('Withdraw')); ?></button>
			</div>
		</div>

		<div class="space-y-2">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Recent Transactions')); ?></p>
			<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
				<div class="bg-card rounded-xl p-3 border border-border flex items-center justify-between">
					<div>
						<p class="text-sm font-semibold text-foreground"><?php echo e(ucfirst(str_replace('_', ' ', $transaction->type))); ?></p>
						<p class="text-xs text-muted-foreground"><?php echo e($transaction->created_at?->format('Y-m-d H:i')); ?></p>
					</div>
					<div class="text-right">
						<p class="text-sm font-semibold text-foreground"><?php echo e($transaction->currency_code); ?>

							<?php echo e(number_format((float) $transaction->amount, 2)); ?></p>
						<p class="text-xs text-muted-foreground"><?php echo e(ucfirst($transaction->status)); ?></p>
					</div>
				</div>
			<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
				<p class="text-sm text-muted-foreground"><?php echo e(__('No transactions yet.')); ?></p>
			<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Personal Information')); ?></p>
			<div>
				<label for="name" class="required block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Name')); ?></label>
				<input id="name" type="text" wire:model="name" class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-red-500 text-xs"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>
			<div>
				<label for="email" class="required block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Email')); ?></label>
				<input id="email" type="email" wire:model="email" class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-red-500 text-xs"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>
			<button type="button" wire:click="updateProfileInformation"
				class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
				<?php echo e(__('Save Profile')); ?>

			</button>
		</div>

		<div class="bg-card rounded-xl p-4 border border-border space-y-3">
			<p class="text-sm font-semibold text-foreground"><?php echo e(__('Password & Security')); ?></p>
			<div>
				<label for="current_password" class="required block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Current Password')); ?></label>
				<input id="current_password" type="password" wire:model="current_password"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-red-500 text-xs"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>
			<div>
				<label for="password" class="required block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('New Password')); ?></label>
				<input id="password" type="password" wire:model="password"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
				<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-red-500 text-xs"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
			</div>
			<div>
				<label for="password_confirmation" class="required block text-xs font-medium text-muted-foreground mb-1"><?php echo e(__('Confirm New Password')); ?></label>
				<input id="password_confirmation" type="password" wire:model="password_confirmation"
					class="w-full rounded-md border border-border bg-background px-3 py-2 text-sm text-foreground" />
			</div>
			<button type="button" wire:click="updatePassword"
				class="w-full rounded-md bg-primary px-4 py-2 text-sm font-semibold text-primary-foreground">
				<?php echo e(__('Update Password')); ?>

			</button>
		</div>
	</div>
</div><?php /**PATH /Users/cybertruck/DevProjects/2026/FxZidii/storage/framework/views/livewire/views/aaa296ae.blade.php ENDPATH**/ ?>