<?php

use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

return new #[Layout('layouts.trading')] class extends Component {
    use WithPagination;

    #[Computed]
    public function currencyCode(): string
    {
        return app(DefaultCurrencyService::class)->code();
    }

    #[Computed]
    public function transactions()
    {
        return WalletTransaction::query()
            ->where('user_id', auth()->id())
            ->latest()
            ->paginate(15, ['*'], 'transactions_page');
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/3db8d3c3.blade.php', $data);
    }
}; 