<?php

use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

return new #[Layout('layouts.trading')] class extends Component {
    use WithPagination;

    #[Computed]
    public function currencyCode(): string
    {
        return app(DefaultCurrencyService::class)->code();
    }

    #[Computed]
    public function transactions()
    {
        return WalletTransaction::query()
            ->where('user_id', auth()->id())
            ->latest()
            ->paginate(15, ['*'], 'transactions_page');
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidiaik/home.ziiditrader.com/storage/framework/views/livewire/views/6fb390c7.blade.php', $data);
    }
}; 