<?php

use App\Models\Vrm\Utility;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Layout;
use Livewire\Component;

return new class extends Component {
    use WithNotifications;

    public string $walletTill = '';

    public function mount(): void
    {
        $this->useToasts();
        
        $utility = Utility::where('key', 'wallet_till')->first();
        if ($utility) {
            $this->walletTill = $utility->value ?? '';
        }
    }

    public function save(): void
    {
        $this->validate([
            'walletTill' => 'required|string',
        ]);

        Utility::updateOrCreate(
            ['key' => 'wallet_till'],
            [
                'value' => $this->walletTill,
                'type' => 'string',
                'is_public' => false,
                'is_active' => true,
            ]
        );

        $this->notifySuccess(__('Wallet Till updated successfully.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/7ed25068.blade.php', $data);
    }
}; 