<?php

use App\Services\Trading\TradingSettingsService;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Component;

return new class extends Component {
    use WithNotifications;

    public string $sendNotificationEmail = '1';

    public string $sendNotificationSms = '1';

    public string $userOtpSms = '1';

    public string $userOtpEmail = '1';

    public string $userTransactionSms = '1';

    public string $userTransactionEmail = '1';

    public string $userWelcomeSms = '1';

    public string $userWelcomeEmail = '1';

    public string $userPasswordUpdatedSms = '1';

    public string $userPasswordUpdatedEmail = '1';

    public string $adminDepositSms = '1';

    public string $adminDepositEmail = '1';

    public string $adminTransactionSms = '1';

    public string $adminTransactionEmail = '1';

    public function mount(TradingSettingsService $settings): void
    {
        $this->sendNotificationEmail = $settings->emailNotificationsEnabled() ? '1' : '0';
        $this->sendNotificationSms = $settings->smsNotificationsEnabled() ? '1' : '0';
        $this->userOtpSms = $settings->getGranularNotificationRaw('notification_user_otp_sms_enabled') ? '1' : '0';
        $this->userOtpEmail = $settings->getGranularNotificationRaw('notification_user_otp_email_enabled') ? '1' : '0';
        $this->userTransactionSms = $settings->getGranularNotificationRaw('notification_user_transaction_sms_enabled') ? '1' : '0';
        $this->userTransactionEmail = $settings->getGranularNotificationRaw('notification_user_transaction_email_enabled') ? '1' : '0';
        $this->userWelcomeSms = $settings->getGranularNotificationRaw('notification_user_welcome_sms_enabled') ? '1' : '0';
        $this->userWelcomeEmail = $settings->getGranularNotificationRaw('notification_user_welcome_email_enabled') ? '1' : '0';
        $this->userPasswordUpdatedSms = $settings->getGranularNotificationRaw('notification_user_password_updated_sms_enabled') ? '1' : '0';
        $this->userPasswordUpdatedEmail = $settings->getGranularNotificationRaw('notification_user_password_updated_email_enabled') ? '1' : '0';
        $this->adminDepositSms = $settings->getGranularNotificationRaw('notification_admin_deposit_sms_enabled') ? '1' : '0';
        $this->adminDepositEmail = $settings->getGranularNotificationRaw('notification_admin_deposit_email_enabled') ? '1' : '0';
        $this->adminTransactionSms = $settings->getGranularNotificationRaw('notification_admin_transaction_sms_enabled') ? '1' : '0';
        $this->adminTransactionEmail = $settings->getGranularNotificationRaw('notification_admin_transaction_email_enabled') ? '1' : '0';
    }

    /**
     * @return array<int, array{sms_id: string, email_id: string, sms_prop: string, email_prop: string, label: string}>
     */
    protected function granularRows(): array
    {
        return [
            ['sms_id' => 'userOtpSms', 'email_id' => 'userOtpEmail', 'sms_prop' => 'userOtpSms', 'email_prop' => 'userOtpEmail', 'label' => __('User OTP (verification & password reset)')],
            ['sms_id' => 'userTransactionSms', 'email_id' => 'userTransactionEmail', 'sms_prop' => 'userTransactionSms', 'email_prop' => 'userTransactionEmail', 'label' => __('User transaction (deposit, withdrawal, invest, buy/sell orders, order status)')],
            ['sms_id' => 'userWelcomeSms', 'email_id' => 'userWelcomeEmail', 'sms_prop' => 'userWelcomeSms', 'email_prop' => 'userWelcomeEmail', 'label' => __('User welcome')],
            ['sms_id' => 'userPasswordUpdatedSms', 'email_id' => 'userPasswordUpdatedEmail', 'sms_prop' => 'userPasswordUpdatedSms', 'email_prop' => 'userPasswordUpdatedEmail', 'label' => __('User password updated')],
            ['sms_id' => 'adminDepositSms', 'email_id' => 'adminDepositEmail', 'sms_prop' => 'adminDepositSms', 'email_prop' => 'adminDepositEmail', 'label' => __('Admin deposit notification')],
            ['sms_id' => 'adminTransactionSms', 'email_id' => 'adminTransactionEmail', 'sms_prop' => 'adminTransactionSms', 'email_prop' => 'adminTransactionEmail', 'label' => __('Admin transaction (withdrawals/orders)')],
        ];
    }

    public function save(TradingSettingsService $settings): void
    {
        $validated = $this->validate([
            'sendNotificationEmail' => 'required|in:0,1',
            'sendNotificationSms' => 'required|in:0,1',
            'userOtpSms' => 'required|in:0,1',
            'userOtpEmail' => 'required|in:0,1',
            'userTransactionSms' => 'required|in:0,1',
            'userTransactionEmail' => 'required|in:0,1',
            'userWelcomeSms' => 'required|in:0,1',
            'userWelcomeEmail' => 'required|in:0,1',
            'userPasswordUpdatedSms' => 'required|in:0,1',
            'userPasswordUpdatedEmail' => 'required|in:0,1',
            'adminDepositSms' => 'required|in:0,1',
            'adminDepositEmail' => 'required|in:0,1',
            'adminTransactionSms' => 'required|in:0,1',
            'adminTransactionEmail' => 'required|in:0,1',
        ]);

        $settings->updateNotificationChannels(
            $validated['sendNotificationEmail'] === '1',
            $validated['sendNotificationSms'] === '1',
        );

        $settings->updateNotificationChannelsGranular([
            'notification_user_otp_sms_enabled' => $validated['userOtpSms'] === '1',
            'notification_user_otp_email_enabled' => $validated['userOtpEmail'] === '1',
            'notification_user_transaction_sms_enabled' => $validated['userTransactionSms'] === '1',
            'notification_user_transaction_email_enabled' => $validated['userTransactionEmail'] === '1',
            'notification_user_welcome_sms_enabled' => $validated['userWelcomeSms'] === '1',
            'notification_user_welcome_email_enabled' => $validated['userWelcomeEmail'] === '1',
            'notification_user_password_updated_sms_enabled' => $validated['userPasswordUpdatedSms'] === '1',
            'notification_user_password_updated_email_enabled' => $validated['userPasswordUpdatedEmail'] === '1',
            'notification_admin_deposit_sms_enabled' => $validated['adminDepositSms'] === '1',
            'notification_admin_deposit_email_enabled' => $validated['adminDepositEmail'] === '1',
            'notification_admin_transaction_sms_enabled' => $validated['adminTransactionSms'] === '1',
            'notification_admin_transaction_email_enabled' => $validated['adminTransactionEmail'] === '1',
        ]);

        $this->notifySuccess(__('Notification settings updated successfully.'));
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/83820d90.blade.php', $data);
    }
}; 