<?php

use App\Models\WalletTransaction;
use App\Services\ReceiptPdfService;
use Livewire\Attributes\Layout;
use Livewire\Component;

return new #[Layout('layouts.receipt-print')] class extends Component {
    public array $receipt = [];

    public int $transactionId = 0;

    public function mount(WalletTransaction $transaction): void
    {
        if ((int) $transaction->user_id !== (int) auth()->id()) {
            abort(404);
        }

        if (! $transaction->canDownloadReceipt()) {
            abort(404);
        }

        $this->transactionId = $transaction->id;
        $this->receipt = app(ReceiptPdfService::class)->receiptDataForTransaction(
            $transaction,
            auth()->user()
        );
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/83b1e4d9.blade.php', $data);
    }
}; 