<?php

use Livewire\Attributes\Computed;
use Livewire\Component;

return new class extends Component {
    /** Current theme from user preferences (light or dark). */
    #[Computed]
    public function theme(): string
    {
        $prefs = auth()->user()->preferences ?? [];

        return $prefs['theme'] ?? 'light';
    }

    public function setTheme(string $theme): void
    {
        if (! in_array($theme, ['light', 'dark'], true)) {
            return;
        }

        $user = auth()->user();
        $prefs = $user->preferences ?? [];
        $prefs['theme'] = $theme;
        $user->preferences = $prefs;

        $this->dispatch('theme-changed', theme: $theme);
    }

    protected function view($data = [])
    {
        return app('view')->file('/home/ziidfelj/home.ziidi.trade/storage/framework/views/livewire/views/e8799912.blade.php', $data);
    }
}; 