<?php

use App\Facades\Vrm\MediaForge;
use App\Models\Security;
use App\Traits\Vrm\Livewire\WithNotifications;
use Livewire\Attributes\Validate;
use Livewire\Component;
use Livewire\WithFileUploads;

return new class extends Component {
    use WithFileUploads;
    use WithNotifications;

    #[Validate('required|string|max:20|unique:securities,trading_name')]
    public string $trading_name = '';

    #[Validate('nullable|image|mimes:jpg,jpeg,png,webp|max:2048')]
    public $logo;

    #[Validate('nullable|string|max:3000')]
    public string $description = '';

    public function save(): void
    {
        $this->validate();

        $logoPath = null;

        if ($this->logo) {
            $logoPath = MediaForge::upload($this->logo)
                ->useYearFolder(true)
                ->randomizeFileName(true)
                ->to('securities')
                ->resize(300, 300)
                ->run();
        }

        if (! $logoPath) {
            $logoPath = 'images/securities/'.strtolower($this->trading_name).'.png';
        }

        Security::query()->create([
            'trading_name' => strtoupper($this->trading_name),
            'logo' => $logoPath,
            'description' => $this->description ?: null,
            'is_active' => true,
        ]);

        $this->notifySuccess(__('Security created successfully.'));

        $this->redirect(route('admin.securities.index'), navigate: true);
    }

    protected function view($data = [])
    {
        return app('view')->file('/home1/xxwewbmy/zidii.fxinvest.io/storage/framework/views/livewire/views/f41134c2.blade.php', $data);
    }
}; 