<?php
use App\Models\Wallet;
use App\Models\WalletTransaction;
use App\Jobs\Vrm\SendMail;
use App\Mail\AdminDepositMail;
use App\Mail\WalletTransactionMail;
use App\Services\DefaultCurrencyService;
use App\Services\Investment\SubscriptionService;
use App\Services\Sms\SmsNotifier;
use App\Traits\Vrm\Livewire\WithNotifications;
use Illuminate\Support\Sleep;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
	<div x-data="{ scrolled: false }" x-init="scrolled = window.scrollY > 6;
window.addEventListener('scroll', () => scrolled = window.scrollY > 6)"
		:class="scrolled ? 'bg-zinc-950 border-zinc-800' : 'bg-background border-border'"
		class="sticky top-0 z-40 border-b px-4 py-3 transition-colors duration-200">
		<div class="flex items-start justify-between gap-3">
			<a href="{{ route('member.dashboard') }}" wire:navigate class="mt-1 text-foreground">
				<i class="fa-solid fa-arrow-left text-base"></i>
			</a>
			<div class="flex-1">
				<p class="text-base font-semibold text-foreground">{{ __('Deposit Funds') }}</p>
				<p class="text-sm text-muted-foreground">{{ __('Add funds to start investing') }}</p>
			</div>
			<button type="button" class="mt-1 text-foreground" aria-label="{{ __('Help') }}">
				<i class="fa-regular fa-circle-question text-base"></i>
			</button>
		</div>
	</div>

	<div class="mx-auto w-full max-w-xl px-4 py-5 space-y-4">
		@if (!empty($this->notification))
			<div x-data="{ show: true }" x-show="show" x-transition:enter="transform transition ease-out duration-300"
				x-transition:enter-start="translate-y-3 opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
				x-transition:leave="transform transition ease-in duration-200"
				x-transition:leave-start="translate-y-0 opacity-100" x-transition:leave-end="translate-y-3 opacity-0"
				x-init="setTimeout(() => {
    show = false;
    $wire.clearNotification();
}, 3500)"
				class="fixed inset-x-0 bottom-24 z-[96] px-4 lg:bottom-6 [&_.toast]:mx-auto [&_.toast]:max-w-sm [&_.toast]:w-full">
				{!! $this->renderNotification() !!}
			</div>
		@endif

		@if ($depositStep === 'form')
			<div class="bg-card rounded-2xl border border-border p-4 sm:p-5 space-y-4">
				<div class="rounded-xl border border-emerald-500/60 bg-primary/10 p-3.5">
					<div class="flex items-center gap-3">
						<div class="size-11 rounded-xl bg-emerald-600 text-white flex items-center justify-center text-md font-bold">M
						</div>
						<div>
							<p class="text-sm font-semibold text-white">{{ __('M-Pesa Instant Deposit') }}</p>
							<p class="text-xs text-white/90">{{ __('Fast & secure mobile money transfer') }}</p>
						</div>
					</div>
				</div>

				@if ($intent === \App\Services\Investment\SubscriptionService::META_INTENT_SUBSCRIPTION)
					<div class="rounded-xl border border-primary/30 bg-primary/10 px-3 py-2 text-xs text-primary">
						{{ __('Top up this amount to complete your package subscription after admin approval.') }}
					</div>
				@endif

				<div class="space-y-2">
					<label class="block text-sm font-medium text-foreground">{{ __('Phone Number') }}</label>
					<div class="relative">
						<i class="fa-solid fa-phone absolute left-4 top-1/2 -translate-y-1/2 text-sm text-muted-foreground"></i>
						<input type="text" wire:model="phoneNumber"
							maxlength="13"
							class="w-full rounded-xl border border-border bg-background py-2.5 pl-11 pr-4 text-sm text-foreground"
							placeholder="0712345678 / 0112345678 / 254712345678" />
					</div>
					<p class="text-xs text-muted-foreground">{{ __('Enter your M-Pesa registered phone number (e.g. 0712345678, 0112345678, or 254712345678)') }}
					</p>
					<span class="text-destructive text-xs">{{ $errors->first('phoneNumber') }}</span>
				</div>

				<div class="space-y-2">
					<label class="block text-sm font-medium text-foreground">{{ __('Amount (Ksh)') }}</label>
					<input type="number" step="0.01" min="45150" max="250000" wire:model="amount"
						class="w-full rounded-xl border border-border bg-background px-4 py-2.5 text-sm text-foreground"
						placeholder="0.00" />
					<p class="text-xs text-muted-foreground">{{ __('Min: 45150 Ksh') }}</p>
					<span class="text-destructive text-xs">{{ $errors->first('amount') }}</span>
				</div>

				<button type="button" wire:click="submitDepositRequest" wire:loading.attr="disabled"
					class="w-full rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-black disabled:cursor-not-allowed disabled:opacity-80">
					<span wire:loading.remove wire:target="submitDepositRequest">{{ __('Deposit with M-Pesa') }}</span>
					<span wire:loading wire:target="submitDepositRequest" class="inline-flex items-center gap-2">
						<i class="fa-solid fa-spinner animate-spin text-sm"></i>
						{{ __('Sending Request') }}
					</span>
				</button>

				<div class="flex items-center justify-center gap-5 text-xs text-muted-foreground">
					<span><i class="fa-solid fa-shield mr-1"></i>{{ __('Secure') }}</span>
					<span><i class="fa-solid fa-bolt mr-1"></i>{{ __('Instant') }}</span>
					<span><i class="fa-regular fa-circle-check mr-1"></i>{{ __('No Fees') }}</span>
				</div>
			</div>
		@else
			<div class="bg-card rounded-2xl border border-border p-5 sm:p-6 min-h-[52vh] flex flex-col">
				<div class="pt-3 space-y-4 text-center mb-4">
					<div class="mx-auto size-16 rounded-full bg-green-600 text-white flex items-center justify-center">
						<i class="fa-solid fa-circle-check text-2xl"></i>
					</div>
					<p class="text-lg font-bold text-foreground">{{ __('Payment Request Sent') }}</p>
				</div>

				<div class="my-auto space-y-6 rounded-xl border border-border bg-background p-5 mb-4">
					<p class="text-sm text-foreground">
						{{ __('Check your phone (:phone) and enter your M-Pesa PIN to complete the deposit of :amount.', ['phone' => $this->phoneNumber, 'amount' => number_format($submittedDepositAmount, 2)]) }}
					</p>
					<p class="text-sm font-semibold text-foreground">
						{{ __('This request expires in 60 seconds.') }}
					</p>
				</div>

				<div class="mt-auto grid grid-cols-2 gap-3">
					<button type="button" wire:click="resetDepositFlow"
						class="w-full rounded-xl bg-muted px-4 py-2.5 text-sm font-semibold text-muted-foreground">
						{{ __('Cancel') }}
					</button>
					<button type="button" wire:click="completePayment"
						class="w-full rounded-xl bg-[#2CB34A] px-4 py-2.5 text-sm font-semibold text-black">
						{{ __('I\'ve Completed Payment') }}
					</button>
				</div>
			</div>
		@endif
	</div>
</div>