<?php
use App\Models\WalletTransaction;
use App\Services\DefaultCurrencyService;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
	@include('partials.trading.topbar', ['title' => 'Transactions'])

	<div class="space-y-3 px-4 py-4">
		<p class="text-sm font-semibold text-foreground">{{ __('Transaction') }}</p>

		@forelse ($this->transactions as $transaction)
			<div wire:key="transaction-{{ $transaction->id }}"
				class="flex items-center justify-between rounded-xl border border-border bg-card p-3">
				<div>
					<p class="text-sm font-semibold text-foreground">{{ ucfirst(str_replace('_', ' ', $transaction->type)) }}</p>
					<p class="text-xs text-muted-foreground">{{ $transaction->created_at?->format('Y-m-d H:i') }}</p>
				</div>
				<div class="text-right">
					<p class="text-sm font-semibold text-foreground">{{ $this->currencyCode }}
						{{ number_format((float) $transaction->amount, 2) }}</p>
					@php($normalizedStatus = strtolower((string) $transaction->status))
					<p
						class="text-xs text-muted-foreground transaction-status {{ $normalizedStatus === 'pending' ? 'transaction-status--pending' : (in_array($normalizedStatus, ['approved', 'completed'], true) ? 'transaction-status--approved' : '') }}">
						{{ ucfirst($transaction->status) }}
					</p>
				</div>
			</div>
		@empty
			<p class="text-sm text-muted-foreground">{{ __('No transactions yet.') }}</p>
		@endforelse

		@if ($this->transactions->hasPages())
			<div class="pt-1">
				{{ $this->transactions->links() }}
			</div>
		@endif
	</div>
</div>