<?php
use App\Models\CommunityPost;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Str;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;
?>

<div>
    @include('partials.trading.topbar', ['title' => __('Community Center')])

    <div class="space-y-4 px-4 py-4">
        @forelse ($this->posts as $post)
            <article class="rounded-2xl border border-border bg-card p-4 shadow-sm sm:p-5">
                <div class="flex items-center justify-between gap-2">
                    <div>
                        <p class="text-sm font-semibold text-foreground">{{ $post->author?->name ?? __('Admin') }}</p>
                        <p class="mt-1 text-xs text-muted-foreground">
                            {{ optional($post->published_at)->diffForHumans() }}
                        </p>
                    </div>
                    <a href="{{ route('member.community.show', ['post' => $post->id]) }}" wire:navigate
                        class="text-xs font-semibold text-primary hover:text-primary/80">
                        {{ __('Open') }}
                    </a>
                </div>

                <h2 class="mt-3 text-base font-bold text-foreground sm:text-lg">{{ $post->title }}</h2>
                <p class="mt-3 whitespace-pre-line text-sm text-muted-foreground">{{ $this->excerpt($post->body_html) }}</p>
            </article>
        @empty
            <div class="rounded-2xl border border-dashed border-border px-4 py-8 text-center text-sm text-muted-foreground">
                {{ __('No community updates yet.') }}
            </div>
        @endforelse

        @if ($this->posts->hasPages())
            <div class="pt-2">
                {{ $this->posts->links() }}
            </div>
        @endif
    </div>
</div>