<?php
use App\Models\Security;
use App\Models\SecurityOrder;
use App\Services\LiveStockService;
use App\Services\Trading\TradingSettingsService;
use App\Models\Wallet;
use Livewire\Attributes\Computed;
use Livewire\Attributes\Layout;
use Livewire\Component;
?>

<div>
    @include('partials.trading.topbar', ['title' => 'FX ZIDII'])
    @include('partials.trading.marquee', ['securities' => $this->securities])

    <div class="px-4 py-4 space-y-4">
        <div class="{{ $this->isMarketOpen ? 'bg-primary/10 border border-primary/30' : 'bg-destructive/10 border border-destructive/30' }} flex items-center justify-between rounded-lg px-4 py-3">
            <div class="flex items-center gap-2">
                <i class="fa-solid fa-circle-info h-4 w-4 {{ $this->isMarketOpen ? 'text-primary' : 'text-destructive' }}"></i>
                <span class="text-sm font-medium {{ $this->isMarketOpen ? 'text-primary' : 'text-destructive' }}">
                    {{ $this->isMarketOpen ? __('Market is open') : __('Market is closed for today.') }}
                </span>
            </div>
        </div>

        <div class="bg-card rounded-xl p-5 border border-border">
            <p class="text-muted-foreground text-sm mb-1">{{ __('Your portfolio value') }}</p>
            <h2 class="text-3xl font-bold text-foreground mb-3">{{ $this->portfolio['currency'] }} {{ number_format($this->portfolio['balance'], 2) }}</h2>
            <div class="border-t border-border pt-3 flex items-center justify-between">
                <span class="text-muted-foreground text-sm">{{ __('Value') }} : {{ $this->portfolio['currency'] }} {{ number_format($this->portfolio['balance'] + $this->portfolio['inTrade'], 2) }}</span>
                <span class="text-sm font-semibold px-4 py-1 rounded-full {{ $this->portfolio['gainLoss'] >= 0 ? 'bg-primary text-primary-foreground' : 'bg-destructive text-destructive-foreground' }}">
                    {{ $this->portfolio['gainLoss'] >= 0 ? '+' : '' }}{{ number_format($this->portfolio['gainLoss'], 2) }}%
                </span>
            </div>
        </div>

        <div class="bg-card rounded-xl p-4 border border-border flex items-center justify-between">
            <div>
                <p class="text-muted-foreground text-xs">{{ __('Balance') }}</p>
                <p class="text-foreground font-semibold">{{ $this->portfolio['currency'] }} {{ number_format($this->portfolio['balance'], 2) }}</p>
            </div>
            <div class="text-right">
                <p class="text-muted-foreground text-xs">{{ __('In Trade') }}</p>
                <div class="flex items-center gap-2">
                    <p class="text-foreground font-semibold">{{ $this->portfolio['currency'] }} {{ number_format($this->portfolio['inTrade'], 2) }}</p>
                    <span class="text-xs font-bold px-2 py-0.5 rounded-full {{ $this->portfolio['gainLoss'] >= 0 ? 'bg-gain/20 text-gain' : 'bg-loss/20 text-loss' }}">
                        {{ $this->portfolio['gainLoss'] >= 0 ? '+' : '' }}{{ number_format($this->portfolio['gainLoss'], 2) }}%
                    </span>
                </div>
            </div>
        </div>

        @if ($this->newestSecurity)
            <div class="bg-card rounded-xl p-4 border border-primary/30 border-dashed">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-primary/20 rounded-full flex items-center justify-center">
                        <i class="fa-solid fa-arrow-trend-up h-5 w-5 text-primary"></i>
                    </div>
                    <div class="flex-1">
                        <p class="text-foreground text-sm">
                            <span class="font-semibold">{{ $this->newestSecurity['name'] }}</span> {{ __('is now listed for trading') }}
                        </p>
                    </div>
                    <a href="{{ route('member.trade') }}" wire:navigate class="text-sm font-medium text-primary border border-primary rounded-lg px-3 py-1.5">{{ __('Go to Trade') }}</a>
                </div>
            </div>
        @endif

        <div class="bg-card rounded-xl p-5 border border-border">
            <div class="flex items-center gap-2 mb-3">
                <i class="fa-solid fa-clock h-4 w-4 text-muted-foreground"></i>
                <h3 class="text-foreground font-semibold text-sm">{{ __('Pending Orders') }}</h3>
            </div>
            <div class="bg-destructive/10 rounded-lg p-4 text-center">
                @if ($this->pendingOrdersCount > 0)
                    <p class="text-foreground text-sm mb-3">{{ __('You have :count pending orders awaiting admin approval.', ['count' => $this->pendingOrdersCount]) }}</p>
                @else
                    <p class="text-foreground text-sm mb-3">{{ __('There are no pending orders yet, click the button to start!') }}</p>
                @endif
                <a href="{{ route('member.trade') }}" wire:navigate class="inline-block bg-primary text-primary-foreground font-semibold py-2.5 px-6 rounded-lg text-sm">{{ __('Go to trading') }}</a>
            </div>
        </div>

        <div class="bg-card rounded-xl p-4 border border-border">
            <div class="flex items-center gap-2 mb-3">
                <i class="fa-solid fa-star h-4 w-4 text-primary"></i>
                <h3 class="text-foreground font-semibold text-sm">{{ __('Your Watchlist') }}</h3>
            </div>
            @if (count($this->watchlist) === 0)
                <p class="text-muted-foreground text-sm text-center py-4">{{ __('Your watchlist is empty') }}</p>
            @else
                <div class="space-y-3">
                    @foreach ($this->watchlist as $s)
                        <div class="flex items-center justify-between py-2" wire:key="watch-{{ $s['id'] }}">
                            <div>
                                <p class="text-foreground font-semibold text-sm">{{ $s['symbol'] }}</p>
                                <p class="text-muted-foreground text-xs">{{ $s['name'] }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-foreground font-semibold text-sm">{{ number_format($s['price'], 2) }}</p>
                                <p class="text-xs {{ $s['change'] >= 0 ? 'text-gain' : 'text-loss' }}">{{ $s['change'] >= 0 ? '▲' : '▼' }}{{ number_format(abs($s['change']), 2) }}%</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        <div class="fixed bottom-24 right-4 z-40 max-w-lg">
            <a href="{{ route('member.trade') }}" wire:navigate class="flex items-center gap-2 bg-primary text-primary-foreground font-semibold py-3 px-6 rounded-full shadow-lg hover:opacity-90 transition-opacity">
                <i class="fa-solid fa-cart-shopping h-5 w-5"></i>
                {{ __('Buy Stocks') }}
            </a>
        </div>
    </div>
</div>